/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.c2.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowIdHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowIdHolder.class);
    private static final String FLOW_IDENTIFIER_FILENAME = "flow-identifier";
    private volatile String flowId;
    private final String configDirectoryName;

    public FlowIdHolder(String configDirectoryName) {
        this.configDirectoryName = configDirectoryName;
        this.flowId = this.readFlowId();
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
        this.persistFlowId(flowId);
    }

    private void persistFlowId(String flowId) {
        File flowIdFile = new File(this.configDirectoryName, FLOW_IDENTIFIER_FILENAME);
        try {
            FileUtils.ensureDirectoryExistAndCanAccess((File)flowIdFile.getParentFile());
            this.saveFlowId(flowIdFile, flowId);
        }
        catch (IOException e) {
            LOGGER.error("Persisting Flow [{}] failed", (Object)flowId, (Object)e);
        }
    }

    private void saveFlowId(File flowUpdateInfoFile, String flowId) {
        try {
            Files.write(flowUpdateInfoFile.toPath(), Collections.singletonList(flowId), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Writing Flow [{}] failed", (Object)flowId, (Object)e);
        }
    }

    private String readFlowId() {
        File flowUpdateInfoFile = new File(this.configDirectoryName, FLOW_IDENTIFIER_FILENAME);
        String flowId = null;
        if (flowUpdateInfoFile.exists()) {
            try {
                List<String> fileLines = Files.readAllLines(flowUpdateInfoFile.toPath());
                if (fileLines.size() != 1) {
                    throw new IllegalStateException(String.format("The file %s for the persisted flow id has the incorrect format.", flowUpdateInfoFile));
                }
                flowId = fileLines.get(0);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not read file %s for persisted flow id.", flowUpdateInfoFile), e);
            }
        }
        return flowId;
    }
}

