/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.c2.client.api.C2Client;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.client.service.operation.OperandPropertiesProvider;
import org.apache.nifi.c2.client.service.operation.SyncResourceStrategy;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.apache.nifi.c2.protocol.api.ResourceItem;
import org.apache.nifi.c2.protocol.api.ResourcesGlobalHash;
import org.apache.nifi.c2.serializer.C2Serializer;
import org.apache.nifi.c2.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncResourceOperationHandler
implements C2OperationHandler {
    static final String GLOBAL_HASH_FIELD = "globalHash";
    static final String RESOURCE_LIST_FIELD = "resourceList";
    private static final Logger LOG = LoggerFactory.getLogger(SyncResourceOperationHandler.class);
    private final C2Client c2Client;
    private final OperandPropertiesProvider operandPropertiesProvider;
    private final SyncResourceStrategy syncResourceStrategy;
    private final C2Serializer c2Serializer;

    public SyncResourceOperationHandler(C2Client c2Client, OperandPropertiesProvider operandPropertiesProvider, SyncResourceStrategy syncResourceStrategy, C2Serializer c2Serializer) {
        this.c2Client = c2Client;
        this.operandPropertiesProvider = operandPropertiesProvider;
        this.syncResourceStrategy = syncResourceStrategy;
        this.c2Serializer = c2Serializer;
    }

    public static SyncResourceOperationHandler create(C2Client c2Client, OperandPropertiesProvider operandPropertiesProvider, SyncResourceStrategy syncResourceStrategy, C2Serializer c2Serializer) {
        Preconditions.requires((c2Client != null ? 1 : 0) != 0, (String)"C2Client should not be null");
        Preconditions.requires((operandPropertiesProvider != null ? 1 : 0) != 0, (String)"OperandPropertiesProvider should not be not null");
        Preconditions.requires((syncResourceStrategy != null ? 1 : 0) != 0, (String)"Sync resource strategy should not be null");
        Preconditions.requires((c2Serializer != null ? 1 : 0) != 0, (String)"C2 serializer should not be null");
        return new SyncResourceOperationHandler(c2Client, operandPropertiesProvider, syncResourceStrategy, c2Serializer);
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.SYNC;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.RESOURCE;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.operandPropertiesProvider.getProperties();
    }

    @Override
    public C2OperationAck handle(C2Operation operation) {
        List<ResourceItem> resourceItems;
        ResourcesGlobalHash resourcesGlobalHash;
        String operationId = Optional.ofNullable(operation.getIdentifier()).orElse("");
        try {
            resourcesGlobalHash = this.getOperationArg(operation, GLOBAL_HASH_FIELD, new TypeReference<ResourcesGlobalHash>(this){}, this.c2Serializer);
        }
        catch (Exception e) {
            LOG.error("Resources global hash could not be constructed from C2 request");
            return this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NOT_APPLIED, "Resources global hash element was not found", e));
        }
        try {
            resourceItems = this.getOperationArg(operation, RESOURCE_LIST_FIELD, new TypeReference<List<ResourceItem>>(this){}, this.c2Serializer);
        }
        catch (Exception e) {
            LOG.error("Resource item list could not be constructed from C2 request");
            return this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NOT_APPLIED, "Resource item list element was not found", e));
        }
        C2OperationState.OperationState operationState = this.syncResourceStrategy.synchronizeResourceRepository(resourcesGlobalHash, resourceItems, (arg_0, arg_1) -> ((C2Client)this.c2Client).retrieveResourceItem(arg_0, arg_1), relativeUrl -> this.c2Client.getCallbackUrl(null, relativeUrl));
        C2OperationState resultState = this.operationState(operationState, switch (operationState) {
            case C2OperationState.OperationState.NOT_APPLIED -> "No resource items were retrieved, please check the log for errors";
            case C2OperationState.OperationState.PARTIALLY_APPLIED -> "Resource repository is partially synced, retrieving some items failed. Pleas check log for errors";
            case C2OperationState.OperationState.FULLY_APPLIED -> "Agent Resource repository is in sync with the C2 server";
            default -> "Unexpected status, please check the log for errors";
        });
        return this.operationAck(operationId, resultState);
    }
}

