/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.apache.nifi.c2.client.api.C2Client;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.client.service.operation.OperandPropertiesProvider;
import org.apache.nifi.c2.protocol.api.C2Operation;
import org.apache.nifi.c2.protocol.api.C2OperationAck;
import org.apache.nifi.c2.protocol.api.C2OperationState;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.apache.nifi.c2.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAssetOperationHandler
implements C2OperationHandler {
    static final String ASSET_URL_KEY = "url";
    static final String ASSET_RELATIVE_URL_KEY = "relativeUrl";
    static final String ASSET_FILE_KEY = "file";
    static final String ASSET_FORCE_DOWNLOAD_KEY = "forceDownload";
    static final String C2_CALLBACK_URL_NOT_FOUND = "C2 Server callback URL was not found in request";
    static final String ASSET_FILE_NAME_NOT_FOUND = "Asset file name was not found in request";
    static final String SUCCESSFULLY_UPDATE_ASSET = "Successfully update asset";
    static final String FAILED_TO_PERSIST_ASSET_TO_DISK = "Failed to persist asset to disk";
    static final String UPDATE_ASSET_RETRIEVAL_RESULTED_IN_EMPTY_CONTENT = "Update asset retrieval resulted in empty content";
    static final String UPDATE_ASSET_PRECONDITIONS_WERE_NOT_MET = "Update asset preconditions were not met. No update will be performed";
    private static final Logger LOG = LoggerFactory.getLogger(UpdateAssetOperationHandler.class);
    private final C2Client c2Client;
    private final OperandPropertiesProvider operandPropertiesProvider;
    private final BiPredicate<String, Boolean> assetUpdatePrecondition;
    private final BiFunction<String, byte[], Boolean> assetPersistFunction;

    public UpdateAssetOperationHandler(C2Client c2Client, OperandPropertiesProvider operandPropertiesProvider, BiPredicate<String, Boolean> assetUpdatePrecondition, BiFunction<String, byte[], Boolean> assetPersistFunction) {
        this.c2Client = c2Client;
        this.operandPropertiesProvider = operandPropertiesProvider;
        this.assetUpdatePrecondition = assetUpdatePrecondition;
        this.assetPersistFunction = assetPersistFunction;
    }

    public static UpdateAssetOperationHandler create(C2Client c2Client, OperandPropertiesProvider operandPropertiesProvider, BiPredicate<String, Boolean> assetUpdatePrecondition, BiFunction<String, byte[], Boolean> assetPersistFunction) {
        Preconditions.requires((c2Client != null ? 1 : 0) != 0, (String)"C2Client should not be null");
        Preconditions.requires((operandPropertiesProvider != null ? 1 : 0) != 0, (String)"OperandPropertiesProvider should not be not null");
        Preconditions.requires((assetUpdatePrecondition != null ? 1 : 0) != 0, (String)"Asset update precondition should not be null");
        Preconditions.requires((assetPersistFunction != null ? 1 : 0) != 0, (String)"Asset persist function should not be null");
        return new UpdateAssetOperationHandler(c2Client, operandPropertiesProvider, assetUpdatePrecondition, assetPersistFunction);
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.UPDATE;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.ASSET;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.operandPropertiesProvider.getProperties();
    }

    @Override
    public C2OperationAck handle(C2Operation operation) {
        String callbackUrl;
        String operationId = Optional.ofNullable(operation.getIdentifier()).orElse("");
        try {
            callbackUrl = this.c2Client.getCallbackUrl(this.getOperationArg(operation, ASSET_URL_KEY).orElse(""), this.getOperationArg(operation, ASSET_RELATIVE_URL_KEY).orElse(""));
        }
        catch (Exception e) {
            LOG.error("Callback URL could not be constructed from C2 request and current configuration");
            return this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NOT_APPLIED, C2_CALLBACK_URL_NOT_FOUND));
        }
        Optional<String> assetFileName = this.getOperationArg(operation, ASSET_FILE_KEY);
        if (assetFileName.isEmpty()) {
            LOG.error("Asset file name with key={} was not found in C2 request. C2 request arguments={}", (Object)ASSET_FILE_KEY, (Object)operation.getArgs());
            return this.operationAck(operationId, this.operationState(C2OperationState.OperationState.NOT_APPLIED, ASSET_FILE_NAME_NOT_FOUND));
        }
        boolean forceDownload = this.getOperationArg(operation, ASSET_FORCE_DOWNLOAD_KEY).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
        LOG.info("Initiating asset update from url {} with name {}, force update is {}", new Object[]{callbackUrl, assetFileName, forceDownload});
        C2OperationState operationState = this.assetUpdatePrecondition.test(assetFileName.get(), forceDownload) ? this.c2Client.retrieveUpdateAssetContent(callbackUrl).map(content -> this.assetPersistFunction.apply((String)assetFileName.get(), (byte[])content) != false ? this.operationState(C2OperationState.OperationState.FULLY_APPLIED, SUCCESSFULLY_UPDATE_ASSET) : this.operationState(C2OperationState.OperationState.NOT_APPLIED, FAILED_TO_PERSIST_ASSET_TO_DISK)).orElseGet(() -> this.operationState(C2OperationState.OperationState.NOT_APPLIED, UPDATE_ASSET_RETRIEVAL_RESULTED_IN_EMPTY_CONTENT)) : this.operationState(C2OperationState.OperationState.NO_OPERATION, UPDATE_ASSET_PRECONDITIONS_WERE_NOT_MET);
        return this.operationAck(operationId, operationState);
    }
}

