/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.service.operation;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.c2.client.service.operation.C2OperationHandler;
import org.apache.nifi.c2.protocol.api.OperandType;
import org.apache.nifi.c2.protocol.api.OperationType;
import org.apache.nifi.c2.protocol.api.SupportedOperation;

public class SupportedOperationsProvider {
    private final Map<OperationType, Map<OperandType, C2OperationHandler>> operationHandlers;

    public SupportedOperationsProvider(Map<OperationType, Map<OperandType, C2OperationHandler>> handlers) {
        this.operationHandlers = handlers;
    }

    public Set<SupportedOperation> getSupportedOperations() {
        return this.operationHandlers.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(operationEntry -> this.getSupportedOperation((OperationType)operationEntry.getKey(), (Map)operationEntry.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private SupportedOperation getSupportedOperation(OperationType operationType, Map<OperandType, C2OperationHandler> operands) {
        SupportedOperation supportedOperation = new SupportedOperation();
        supportedOperation.setType(operationType);
        Map properties = operands.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toMap(C2OperationHandler::getOperandType, C2OperationHandler::getProperties, (existing, replacement) -> existing, LinkedHashMap::new));
        supportedOperation.setProperties(properties);
        return supportedOperation;
    }
}

