/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.client.http;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.c2.client.C2ClientConfig;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientProvider {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpClientProvider.class);
    private final C2ClientConfig clientConfig;

    public OkHttpClientProvider(C2ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public OkHttpClient okHttpClient() {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)logger).debug(arg_0));
        logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        okHttpClientBuilder.followRedirects(true);
        okHttpClientBuilder.connectionPool(new ConnectionPool(this.clientConfig.getMaxIdleConnections(), this.clientConfig.getKeepAliveDuration(), TimeUnit.MILLISECONDS));
        okHttpClientBuilder.connectTimeout(this.clientConfig.getConnectTimeout(), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.readTimeout(this.clientConfig.getReadTimeout(), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.callTimeout(this.clientConfig.getCallTimeout(), TimeUnit.MILLISECONDS);
        if (StringUtils.isNotBlank((CharSequence)this.clientConfig.getKeystoreFilename())) {
            try {
                this.setSslSocketFactory(okHttpClientBuilder);
            }
            catch (Exception e) {
                throw new IllegalStateException("OkHttp TLS configuration failed", e);
            }
        }
        return okHttpClientBuilder.build();
    }

    private void setSslSocketFactory(OkHttpClient.Builder okHttpClientBuilder) throws Exception {
        KeyStore truststore;
        KeyStore keyStore;
        String keystoreLocation = this.clientConfig.getKeystoreFilename();
        String keystoreType = this.clientConfig.getKeystoreType();
        String keystorePass = this.clientConfig.getKeystorePass();
        this.assertKeystorePropertiesSet(keystoreLocation, keystorePass, keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystoreLocation);){
            keyStore = new StandardKeyStoreBuilder().type(keystoreType).inputStream((InputStream)keyStoreStream).password(keystorePass.toCharArray()).build();
        }
        String truststoreLocation = this.clientConfig.getTruststoreFilename();
        String truststorePass = this.clientConfig.getTruststorePass();
        String truststoreType = this.clientConfig.getTruststoreType();
        this.assertTruststorePropertiesSet(truststoreLocation, truststorePass, truststoreType);
        try (FileInputStream trustStoreStream = new FileInputStream(truststoreLocation);){
            truststore = new StandardKeyStoreBuilder().type(truststoreType).inputStream((InputStream)trustStoreStream).password(truststorePass.toCharArray()).build();
        }
        X509ExtendedTrustManager trustManager = new StandardTrustManagerBuilder().trustStore(truststore).build();
        SSLContext sslContext = new StandardSslContextBuilder().keyStore(keyStore).keyPassword(keystorePass.toCharArray()).trustStore(truststore).build();
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        okHttpClientBuilder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager);
    }

    private void assertKeystorePropertiesSet(String location, String password, String type) {
        if (location == null || location.isEmpty()) {
            throw new IllegalArgumentException(this.clientConfig.getKeystoreFilename() + " is null or is empty");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("The client's keystore filename is set but its password is not (or is empty). If the location is set, the password must also be.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("The client's keystore filename is set but its type is not (or is empty). If the location is set, the type must also be.");
        }
    }

    private void assertTruststorePropertiesSet(String location, String password, String type) {
        if (location == null || location.isEmpty()) {
            throw new IllegalArgumentException("The client's truststore filename is not set or is empty");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("The client's truststore filename is set but its password is not (or is empty). If the location is set, the password must also be.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("The client's truststore filename is set but its type is not (or is empty). If the location is set, the type must also be.");
        }
    }
}

