/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.netbeans.nbm.AbstractNbmMojo;
import org.apache.netbeans.nbm.CreateClusterAppMojo;
import org.apache.netbeans.nbm.utils.ExamineManifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;

@Mojo(name="cluster", aggregator=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CreateClusterMojo
extends AbstractNbmMojo {
    @Parameter(defaultValue="${project.build.directory}/netbeans_clusters", required=true)
    protected File nbmBuildDir;
    @Parameter(defaultValue="extra")
    private String defaultCluster;
    @Parameter(required=true, readonly=true, property="reactorProjects")
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Project antProject = this.registerNbmAntTasks();
        if (!this.nbmBuildDir.exists()) {
            this.nbmBuildDir.mkdirs();
        }
        if (this.reactorProjects != null && this.reactorProjects.size() > 0) {
            for (MavenProject proj : this.reactorProjects) {
                File nbmDir = new File(proj.getBasedir(), "target" + File.separator + "nbm" + File.separator + "netbeans");
                if (nbmDir.exists()) {
                    Copy copyTask = (Copy)antProject.createTask("copy");
                    copyTask.setTodir(this.nbmBuildDir);
                    copyTask.setOverwrite(true);
                    FileSet set = new FileSet();
                    set.setDir(nbmDir);
                    set.createInclude().setName("**");
                    copyTask.addFileset(set);
                    try {
                        copyTask.execute();
                        continue;
                    }
                    catch (BuildException ex) {
                        this.getLog().error((CharSequence)"Cannot merge modules into cluster");
                        throw new MojoExecutionException("Cannot merge modules into cluster", (Exception)((Object)ex));
                    }
                }
                if ("nbm".equals(proj.getPackaging())) {
                    String error = "The NetBeans binary directory structure for " + proj.getId() + " is not created yet.\n Please execute 'mvn install nbm:cluster' to build all relevant projects in the reactor.";
                    throw new MojoFailureException(error);
                }
                if (!"bundle".equals(proj.getPackaging())) continue;
                Artifact art = proj.getArtifact();
                final ExamineManifest mnf = new ExamineManifest(this.getLog());
                File jar = new File(proj.getBuild().getDirectory(), proj.getBuild().getFinalName() + ".jar");
                if (!jar.exists()) {
                    this.getLog().error((CharSequence)("Skipping " + proj.getId() + ". Cannot find the main artifact in output directory."));
                    continue;
                }
                mnf.setJarFile(jar);
                mnf.checkFile();
                File cluster = new File(this.nbmBuildDir, this.defaultCluster);
                this.getLog().debug((CharSequence)("Copying " + art.getId() + " to cluster " + this.defaultCluster));
                File modules = new File(cluster, "modules");
                modules.mkdirs();
                File config = new File(cluster, "config");
                File confModules = new File(config, "Modules");
                confModules.mkdirs();
                File updateTracting = new File(cluster, "update_tracking");
                updateTracting.mkdirs();
                final String cnb = mnf.getModule();
                String cnbDashed = cnb.replace(".", "-");
                final File moduleArt = new File(modules, cnbDashed + ".jar");
                final String specVer = mnf.getSpecVersion();
                try {
                    FileUtils.copyFile((File)jar, (File)moduleArt);
                    final File moduleConf = new File(confModules, cnbDashed + ".xml");
                    FileUtils.copyStreamToFile((InputStreamFacade)new InputStreamFacade(){

                        public InputStream getInputStream() throws IOException {
                            return new StringInputStream(CreateClusterAppMojo.createBundleConfigFile(cnb, mnf.isBundleAutoload()), "UTF-8");
                        }
                    }, (File)moduleConf);
                    FileUtils.copyStreamToFile((InputStreamFacade)new InputStreamFacade(){

                        public InputStream getInputStream() throws IOException {
                            return new StringInputStream(CreateClusterAppMojo.createBundleUpdateTracking(cnb, moduleArt, moduleConf, specVer), "UTF-8");
                        }
                    }, (File)new File(updateTracting, cnbDashed + ".xml"));
                }
                catch (IOException exc) {
                    this.getLog().error((Throwable)exc);
                }
            }
            File[] files = this.nbmBuildDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                File stamp = new File(files[i], ".lastModified");
                if (!stamp.exists()) {
                    try {
                        stamp.createNewFile();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                stamp.setLastModified(new Date().getTime());
            }
        } else {
            throw new MojoExecutionException("This goal only makes sense on reactor projects.");
        }
        this.getLog().info((CharSequence)("Created NetBeans module cluster(s) at " + this.nbmBuildDir));
    }
}

