/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.apr;

import java.net.InetSocketAddress;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.transport.socket.AbstractSocketSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.apr.AprSession;
import org.apache.tomcat.jni.Socket;

class AprSocketSession
extends AprSession {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("apr", "socket", false, true, InetSocketAddress.class, SocketSessionConfig.class, new Class[]{IoBuffer.class});

    AprSocketSession(IoService service, IoProcessor<AprSession> processor, long descriptor) throws Exception {
        super(service, processor, descriptor);
        this.config = new SessionConfigImpl();
        this.config.setAll(service.getSessionConfig());
    }

    public SocketSessionConfig getConfig() {
        return (SocketSessionConfig)this.config;
    }

    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    private class SessionConfigImpl
    extends AbstractSocketSessionConfig {
        private SessionConfigImpl() {
        }

        public boolean isKeepAlive() {
            try {
                return Socket.optGet((long)AprSocketSession.this.getDescriptor(), (int)2) == 1;
            }
            catch (Exception e) {
                throw new RuntimeIoException("Failed to get SO_KEEPALIVE.", (Throwable)e);
            }
        }

        public void setKeepAlive(boolean on) {
            Socket.optSet((long)AprSocketSession.this.getDescriptor(), (int)2, (int)(on ? 1 : 0));
        }

        public boolean isOobInline() {
            return false;
        }

        public void setOobInline(boolean on) {
        }

        public boolean isReuseAddress() {
            try {
                return Socket.optGet((long)AprSocketSession.this.getDescriptor(), (int)16) == 1;
            }
            catch (Exception e) {
                throw new RuntimeIoException("Failed to get SO_REUSEADDR.", (Throwable)e);
            }
        }

        public void setReuseAddress(boolean on) {
            Socket.optSet((long)AprSocketSession.this.getDescriptor(), (int)16, (int)(on ? 1 : 0));
        }

        public int getSoLinger() {
            try {
                return Socket.optGet((long)AprSocketSession.this.getDescriptor(), (int)1);
            }
            catch (Exception e) {
                throw new RuntimeIoException("Failed to get SO_LINGER.", (Throwable)e);
            }
        }

        public void setSoLinger(int linger) {
            Socket.optSet((long)AprSocketSession.this.getDescriptor(), (int)1, (int)linger);
        }

        public boolean isTcpNoDelay() {
            try {
                return Socket.optGet((long)AprSocketSession.this.getDescriptor(), (int)512) == 1;
            }
            catch (Exception e) {
                throw new RuntimeIoException("Failed to get TCP_NODELAY.", (Throwable)e);
            }
        }

        public void setTcpNoDelay(boolean on) {
            Socket.optSet((long)AprSocketSession.this.getDescriptor(), (int)512, (int)(on ? 1 : 0));
        }

        public int getTrafficClass() {
            return 0;
        }

        public void setTrafficClass(int tc) {
        }

        public int getSendBufferSize() {
            try {
                return Socket.optGet((long)AprSocketSession.this.getDescriptor(), (int)64);
            }
            catch (Exception e) {
                throw new IllegalStateException("APR Exception", e);
            }
        }

        public void setSendBufferSize(int size) {
            Socket.optSet((long)AprSocketSession.this.getDescriptor(), (int)64, (int)size);
        }

        public int getReceiveBufferSize() {
            try {
                return Socket.optGet((long)AprSocketSession.this.getDescriptor(), (int)128);
            }
            catch (Exception e) {
                throw new IllegalStateException("APR Exception", e);
            }
        }

        public void setReceiveBufferSize(int size) {
            Socket.optSet((long)AprSocketSession.this.getDescriptor(), (int)128, (int)size);
        }
    }
}

