/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.apr;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.polling.AbstractPollingIoConnector;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.DefaultSocketSessionConfig;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.apr.AprIoProcessor;
import org.apache.mina.transport.socket.apr.AprLibrary;
import org.apache.mina.transport.socket.apr.AprSession;
import org.apache.mina.transport.socket.apr.AprSocketSession;
import org.apache.mina.util.CircularQueue;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Poll;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AprSocketConnector
extends AbstractPollingIoConnector<AprSession, Long>
implements SocketConnector {
    private static final int POLLSET_SIZE = 1024;
    private final Map<Long, AbstractPollingIoConnector.ConnectionRequest> requests = new HashMap<Long, AbstractPollingIoConnector.ConnectionRequest>(1024);
    private final Object wakeupLock = new Object();
    private volatile long wakeupSocket;
    private volatile boolean toBeWakenUp;
    private volatile long pool;
    private volatile long pollset;
    private final long[] polledSockets = new long[2048];
    private final List<Long> polledHandles = new CircularQueue(1024);
    private final Set<Long> failedHandles = new HashSet<Long>(1024);
    private volatile ByteBuffer dummyBuffer;

    public AprSocketConnector() {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), AprIoProcessor.class);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init((IoService)this);
    }

    public AprSocketConnector(int processorCount) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), AprIoProcessor.class, processorCount);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init((IoService)this);
    }

    public AprSocketConnector(IoProcessor<AprSession> processor) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), processor);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init((IoService)this);
    }

    public AprSocketConnector(Executor executor, IoProcessor<AprSession> processor) {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), executor, processor);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init((IoService)this);
    }

    protected void init() throws Exception {
        this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
        this.wakeupSocket = Socket.create((int)1, (int)1, (int)17, (long)this.pool);
        this.dummyBuffer = Pool.alloc((long)this.pool, (int)1);
        this.pollset = Poll.create((int)1024, (long)this.pool, (int)1, (long)Long.MAX_VALUE);
        if (this.pollset <= 0L) {
            this.pollset = Poll.create((int)62, (long)this.pool, (int)1, (long)Long.MAX_VALUE);
        }
        if (this.pollset <= 0L && Status.APR_STATUS_IS_ENOTIMPL((int)(-((int)this.pollset)))) {
            throw new RuntimeIoException("Thread-safe pollset is not supported in this platform.");
        }
    }

    protected void destroy() throws Exception {
        if (this.wakeupSocket > 0L) {
            Socket.close((long)this.wakeupSocket);
        }
        if (this.pollset > 0L) {
            Poll.destroy((long)this.pollset);
        }
        if (this.pool > 0L) {
            Pool.destroy((long)this.pool);
        }
    }

    protected Iterator<Long> allHandles() {
        return this.polledHandles.iterator();
    }

    protected boolean connect(Long handle, SocketAddress remoteAddress) throws Exception {
        InetSocketAddress ra = (InetSocketAddress)remoteAddress;
        long sa = ra != null ? (ra.getAddress() == null ? Address.info((String)Address.APR_ANYADDR, (int)1, (int)ra.getPort(), (int)0, (long)this.pool) : Address.info((String)ra.getAddress().getHostAddress(), (int)1, (int)ra.getPort(), (int)0, (long)this.pool)) : Address.info((String)Address.APR_ANYADDR, (int)1, (int)0, (int)0, (long)this.pool);
        int rv = Socket.connect((long)handle, (long)sa);
        if (rv == 0) {
            return true;
        }
        if (Status.APR_STATUS_IS_EINPROGRESS((int)rv)) {
            return false;
        }
        this.throwException(rv);
        throw new InternalError();
    }

    protected AbstractPollingIoConnector.ConnectionRequest connectionRequest(Long handle) {
        return this.requests.get(handle);
    }

    protected void close(Long handle) throws Exception {
        this.finishConnect(handle);
        int rv = Socket.close((long)handle);
        if (rv != 0) {
            this.throwException(rv);
        }
    }

    protected boolean finishConnect(Long handle) throws Exception {
        Poll.remove((long)this.pollset, (long)handle);
        this.requests.remove(handle);
        if (this.failedHandles.remove(handle)) {
            int rv = Socket.recvb((long)handle, (ByteBuffer)this.dummyBuffer, (int)0, (int)1);
            this.throwException(rv);
            throw new InternalError("Shouldn't reach here.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long newHandle(SocketAddress localAddress) throws Exception {
        long handle = Socket.create((int)1, (int)0, (int)6, (long)this.pool);
        boolean success = false;
        try {
            InetSocketAddress la;
            long sa;
            int result = Socket.optSet((long)handle, (int)8, (int)1);
            if (result != 0) {
                this.throwException(result);
            }
            if ((result = Socket.timeoutSet((long)handle, (long)0L)) != 0) {
                this.throwException(result);
            }
            if (localAddress != null && (result = Socket.bind((long)handle, (long)(sa = (la = (InetSocketAddress)localAddress).getAddress() == null ? Address.info((String)Address.APR_ANYADDR, (int)1, (int)la.getPort(), (int)0, (long)this.pool) : Address.info((String)la.getAddress().getHostAddress(), (int)1, (int)la.getPort(), (int)0, (long)this.pool)))) != 0) {
                this.throwException(result);
            }
            success = true;
            Long l = handle;
            return l;
        }
        finally {
            int rv;
            if (!success && (rv = Socket.close((long)handle)) != 0) {
                this.throwException(rv);
            }
        }
    }

    protected AprSession newSession(IoProcessor<AprSession> processor, Long handle) throws Exception {
        return new AprSocketSession((IoService)this, processor, handle);
    }

    protected void register(Long handle, AbstractPollingIoConnector.ConnectionRequest request) throws Exception {
        int rv = Poll.add((long)this.pollset, (long)handle, (int)4);
        if (rv != 0) {
            this.throwException(rv);
        }
        this.requests.put(handle, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean select(int timeout) throws Exception {
        int rv = Poll.poll((long)this.pollset, (long)(timeout * 1000), (long[])this.polledSockets, (boolean)false);
        if (rv <= 0) {
            if (rv != -120001) {
                this.throwException(rv);
            }
            if ((rv = Poll.maintain((long)this.pollset, (long[])this.polledSockets, (boolean)true)) > 0) {
                for (int i = 0; i < rv; ++i) {
                    Poll.add((long)this.pollset, (long)this.polledSockets[i], (int)4);
                }
            } else if (rv < 0) {
                this.throwException(rv);
            }
            return false;
        }
        rv <<= 1;
        if (!this.polledHandles.isEmpty()) {
            this.polledHandles.clear();
        }
        for (int i = 0; i < rv; ++i) {
            long socket;
            long flag = this.polledSockets[i];
            if ((socket = this.polledSockets[++i]) == this.wakeupSocket) {
                Object object = this.wakeupLock;
                synchronized (object) {
                    Poll.remove((long)this.pollset, (long)this.wakeupSocket);
                    this.toBeWakenUp = false;
                    continue;
                }
            }
            this.polledHandles.add(socket);
            if ((flag & 4L) != 0L) continue;
            this.failedHandles.add(socket);
        }
        return !this.polledHandles.isEmpty();
    }

    protected Iterator<Long> selectedHandles() {
        return this.polledHandles.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeup() {
        if (this.toBeWakenUp) {
            return;
        }
        Object object = this.wakeupLock;
        synchronized (object) {
            this.toBeWakenUp = true;
            Poll.add((long)this.pollset, (long)this.wakeupSocket, (int)4);
        }
    }

    public TransportMetadata getTransportMetadata() {
        return AprSocketSession.METADATA;
    }

    public SocketSessionConfig getSessionConfig() {
        return (SocketSessionConfig)super.getSessionConfig();
    }

    public InetSocketAddress getDefaultRemoteAddress() {
        return (InetSocketAddress)super.getDefaultRemoteAddress();
    }

    public void setDefaultRemoteAddress(InetSocketAddress defaultRemoteAddress) {
        super.setDefaultRemoteAddress((SocketAddress)defaultRemoteAddress);
    }

    private void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

