/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited.serialization;

import org.apache.mina.codec.IoBuffer;
import org.apache.mina.codec.delimited.IoBufferDecoder;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ThriftDynamicMessageDecoder
extends IoBufferDecoder<ThriftSerializedMessage> {
    private final TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());

    @Override
    public ThriftSerializedMessage decode(IoBuffer buffer) {
        return new ThriftSerializedMessage(this.deserializer, buffer);
    }

    public static ThriftDynamicMessageDecoder newInstance() {
        return new ThriftDynamicMessageDecoder();
    }

    public static final class ThriftSerializedMessage {
        private final IoBuffer buffer;
        private final TDeserializer deserializer;

        public ThriftSerializedMessage(TDeserializer deserializer, IoBuffer buffer) {
            this.buffer = buffer;
            this.deserializer = deserializer;
        }

        public <L extends TBase<?, ?>> L get(Class<L> clazz) throws InstantiationException, IllegalAccessException, TException {
            TBase object = (TBase)clazz.newInstance();
            byte[] array = new byte[this.buffer.remaining()];
            this.buffer.get(array);
            this.deserializer.deserialize(object, array);
            return (L)object;
        }
    }
}

