/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine.transition;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.mina.statemachine.State;
import org.apache.mina.statemachine.event.Event;
import org.apache.mina.statemachine.transition.Transition;

public abstract class AbstractTransition
implements Transition {
    private final Object eventId;
    private final State nextState;

    public AbstractTransition(Object eventId) {
        this(eventId, null);
    }

    public AbstractTransition(Object eventId, State nextState) {
        this.eventId = eventId;
        this.nextState = nextState;
    }

    public State getNextState() {
        return this.nextState;
    }

    public boolean execute(Event event) {
        if (!this.eventId.equals("*") && !this.eventId.equals(event.getId())) {
            return false;
        }
        return this.doExecute(event);
    }

    protected abstract boolean doExecute(Event var1);

    public boolean equals(Object o) {
        if (!(o instanceof AbstractTransition)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        AbstractTransition that = (AbstractTransition)o;
        return new EqualsBuilder().append(this.eventId, that.eventId).append((Object)this.nextState, (Object)that.nextState).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 31).append(this.eventId).append((Object)this.nextState).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("eventId", this.eventId).append("nextState", (Object)this.nextState).toString();
    }
}

