/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.codec.delimited.serialization;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.mina.codec.delimited.ByteBufferEncoder;
import org.apache.mina.util.ByteBufferOutputStream;

public class JavaNativeMessageEncoder<OUT extends Serializable>
extends ByteBufferEncoder<OUT> {
    private OUT lastObject;
    private ByteBuffer lastSerialized;

    @Override
    public ByteBuffer encode(OUT message) {
        return this.serialize(message);
    }

    @Override
    public int getEncodedSize(OUT message) {
        return this.serialize(message).remaining();
    }

    private ByteBuffer serialize(OUT message) {
        if (message != this.lastObject) {
            ByteBufferOutputStream ebbosa = new ByteBufferOutputStream();
            ebbosa.setElastic(true);
            try {
                ObjectOutputStream oos = new ObjectOutputStream(ebbosa);
                oos.writeObject(message);
                oos.close();
                this.lastObject = message;
                this.lastSerialized = ebbosa.getByteBuffer();
            }
            catch (IOException e) {
                throw new IllegalStateException("Serialization exception", e);
            }
        }
        return this.lastSerialized;
    }

    @Override
    public void writeTo(OUT message, ByteBuffer buffer) {
        buffer.put(this.serialize(message));
    }
}

