/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.mina.integration.beans.AbstractPropertyEditor;

public class InetAddressEditor
extends AbstractPropertyEditor {
    @Override
    protected String toText(Object value) {
        String hostname = ((InetAddress)value).getHostAddress();
        if (hostname.equals("0:0:0:0:0:0:0:0") || hostname.equals("0.0.0.0") || hostname.equals("00:00:00:00:00:00:00:00")) {
            hostname = "*";
        }
        return hostname;
    }

    @Override
    protected Object toValue(String text) throws IllegalArgumentException {
        if (text.length() == 0 || text.equals("*")) {
            return this.defaultValue();
        }
        try {
            return InetAddress.getByName(text);
        }
        catch (UnknownHostException uhe) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(uhe);
            throw iae;
        }
    }

    @Override
    protected String defaultText() {
        return "*";
    }

    @Override
    protected Object defaultValue() {
        try {
            return InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException();
        }
    }
}

