/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import org.apache.mina.integration.beans.AbstractPropertyEditor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;

public class VmPipeAddressEditor
extends AbstractPropertyEditor {
    @Override
    protected String toText(Object value) {
        return ":" + ((VmPipeAddress)value).getPort();
    }

    @Override
    protected String defaultText() {
        return ":0";
    }

    @Override
    protected Object defaultValue() {
        return new VmPipeAddress(0);
    }

    @Override
    protected Object toValue(String text) throws IllegalArgumentException {
        if (text.startsWith(":")) {
            text = text.substring(1);
        }
        try {
            return new VmPipeAddress(Integer.parseInt(text.trim()));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Illegal VmPipeAddress: " + text);
        }
    }
}

