/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.mina.codec.StatelessProtocolEncoder;
import org.apache.mina.http.api.HttpContentChunk;
import org.apache.mina.http.api.HttpEndOfContent;
import org.apache.mina.http.api.HttpPdu;
import org.apache.mina.http.api.HttpPduEncodingVisitor;
import org.apache.mina.http.api.HttpRequest;
import org.apache.mina.http.api.HttpResponse;

public class HttpServerEncoder
implements StatelessProtocolEncoder<HttpPdu, ByteBuffer> {
    private HttpPduEncodingVisitor visitor = new HttpPduEncodingVisitor(){

        @Override
        public ByteBuffer visit(HttpResponse msg) {
            StringBuilder sb = new StringBuilder(msg.getStatus().line());
            for (Map.Entry<String, String> header : msg.getHeaders().entrySet()) {
                sb.append(header.getKey());
                sb.append(": ");
                sb.append(header.getValue());
                sb.append("\r\n");
            }
            sb.append("\r\n");
            byte[] bytes = sb.toString().getBytes(Charset.forName("UTF-8"));
            return ByteBuffer.wrap(bytes);
        }

        @Override
        public ByteBuffer visit(HttpContentChunk msg) {
            return msg.getContent();
        }

        @Override
        public ByteBuffer visit(HttpEndOfContent msg) {
            return null;
        }

        @Override
        public ByteBuffer visit(HttpRequest msg) {
            throw new IllegalStateException("cannot encode that on server side");
        }
    };

    public Void createEncoderState() {
        return null;
    }

    public ByteBuffer encode(HttpPdu message, Void context) {
        return message.encode(this.visitor);
    }
}

