/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.mina.http.api.HttpMethod;
import org.apache.mina.http.api.HttpPduEncodingVisitor;
import org.apache.mina.http.api.HttpRequest;
import org.apache.mina.http.api.HttpVersion;

public class HttpRequestImpl
implements HttpRequest {
    private final HttpVersion version;
    private final HttpMethod method;
    private final String requestedPath;
    private final Map<String, String> headers;

    public HttpRequestImpl(HttpVersion version, HttpMethod method, String requestedPath, Map<String, String> headers) {
        this.version = version;
        this.method = method;
        this.requestedPath = requestedPath;
        this.headers = Collections.unmodifiableMap(headers);
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public String getContentType() {
        return this.headers.get("content-type");
    }

    @Override
    public boolean isKeepAlive() {
        return false;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean containsParameter(String name) {
        return false;
    }

    @Override
    public String getParameter(String name) {
        return null;
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return null;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public ByteBuffer encode(HttpPduEncodingVisitor visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP REQUEST METHOD: ").append((Object)this.method).append('\n');
        sb.append("VERSION: ").append((Object)this.version).append('\n');
        sb.append("PATH: ").append(this.requestedPath).append('\n');
        sb.append("--- HEADER --- \n");
        for (String key : this.headers.keySet()) {
            String value = this.headers.get(key);
            sb.append(key).append(':').append(value).append('\n');
        }
        return sb.toString();
    }
}

