/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.http.ArrayUtil;
import org.apache.mina.http.DecoderState;
import org.apache.mina.http.HttpClientCodec;
import org.apache.mina.http.HttpException;
import org.apache.mina.http.api.DefaultHttpResponse;
import org.apache.mina.http.api.HttpEndOfContent;
import org.apache.mina.http.api.HttpStatus;
import org.apache.mina.http.api.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientDecoder
implements ProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientCodec.class);
    private static final String DECODER_STATE_ATT = "http.ds";
    private static final String PARTIAL_HEAD_ATT = "http.ph";
    private static final String BODY_REMAINING_BYTES = "http.brb";
    private static final String BODY_CHUNKED = "http.ckd";
    public static final Pattern REQUEST_LINE_PATTERN = Pattern.compile(" ");
    public static final Pattern RESPONSE_LINE_PATTERN = Pattern.compile(" ");
    public static final Pattern QUERY_STRING_PATTERN = Pattern.compile("\\?");
    public static final Pattern PARAM_STRING_PATTERN = Pattern.compile("\\&|;");
    public static final Pattern KEY_VALUE_PATTERN = Pattern.compile("=");
    public static final Pattern RAW_VALUE_PATTERN = Pattern.compile("\\r\\n\\r\\n");
    public static final Pattern HEADERS_BODY_PATTERN = Pattern.compile("\\r\\n");
    public static final Pattern HEADER_VALUE_PATTERN = Pattern.compile(": ");
    public static final Pattern COOKIE_SEPARATOR_PATTERN = Pattern.compile(";");

    public void decode(IoSession session, IoBuffer msg, ProtocolDecoderOutput out) {
        DecoderState state = (DecoderState)((Object)session.getAttribute((Object)DECODER_STATE_ATT));
        if (null == state) {
            session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.NEW);
            state = (DecoderState)((Object)session.getAttribute((Object)DECODER_STATE_ATT));
        }
        switch (state) {
            case HEAD: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("decoding HEAD");
                }
                ByteBuffer oldBuffer = (ByteBuffer)session.getAttribute((Object)PARTIAL_HEAD_ATT);
                IoBuffer.allocate((int)(oldBuffer.remaining() + msg.remaining())).put(oldBuffer).put(msg).flip();
            }
            case NEW: {
                DefaultHttpResponse rp;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("decoding NEW");
                }
                if ((rp = this.parseHttpReponseHead(msg.buf())) == null) {
                    ByteBuffer partial = ByteBuffer.allocate(msg.remaining());
                    partial.put(msg.buf());
                    partial.flip();
                    session.setAttribute((Object)PARTIAL_HEAD_ATT, (Object)partial);
                    session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.HEAD);
                    break;
                }
                out.write((Object)rp);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("response with content");
                }
                session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.BODY);
                String contentLen = rp.getHeader("content-length");
                if (contentLen != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("found content len : {}", (Object)contentLen);
                    }
                    session.setAttribute((Object)BODY_REMAINING_BYTES, (Object)Integer.valueOf(contentLen));
                    break;
                }
                if ("chunked".equalsIgnoreCase(rp.getHeader("transfer-encoding"))) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("no content len but chunked");
                    }
                    session.setAttribute((Object)BODY_CHUNKED, (Object)Boolean.TRUE);
                    break;
                }
                if ("close".equalsIgnoreCase(rp.getHeader("connection"))) {
                    session.closeNow();
                    break;
                }
                throw new HttpException(HttpStatus.CLIENT_ERROR_LENGTH_REQUIRED, "no content length !");
            }
            case BODY: {
                int remaining;
                int chunkSize;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("decoding BODY: {} bytes", (Object)msg.remaining());
                }
                if ((chunkSize = msg.remaining()) != 0) {
                    IoBuffer wb = IoBuffer.allocate((int)msg.remaining());
                    wb.put(msg);
                    wb.flip();
                    out.write((Object)wb);
                }
                msg.position(msg.limit());
                if (session.getAttribute((Object)BODY_CHUNKED) != null) {
                    remaining = chunkSize;
                } else {
                    remaining = (Integer)session.getAttribute((Object)BODY_REMAINING_BYTES);
                    remaining -= chunkSize;
                }
                if (remaining <= 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("end of HTTP body");
                    }
                    session.setAttribute((Object)DECODER_STATE_ATT, (Object)DecoderState.NEW);
                    session.removeAttribute((Object)BODY_REMAINING_BYTES);
                    if (session.getAttribute((Object)BODY_CHUNKED) != null) {
                        session.removeAttribute((Object)BODY_CHUNKED);
                    }
                    out.write((Object)new HttpEndOfContent());
                    break;
                }
                if (session.getAttribute((Object)BODY_CHUNKED) != null) break;
                session.setAttribute((Object)BODY_REMAINING_BYTES, (Object)remaining);
                break;
            }
            default: {
                throw new HttpException(HttpStatus.SERVER_ERROR_INTERNAL_SERVER_ERROR, "Unknonwn decoder state : " + (Object)((Object)state));
            }
        }
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public void dispose(IoSession session) throws Exception {
    }

    private DefaultHttpResponse parseHttpReponseHead(ByteBuffer buffer) {
        String raw = new String(buffer.array(), 0, buffer.limit());
        String[] headersAndBody = RAW_VALUE_PATTERN.split(raw, -1);
        if (headersAndBody.length <= 1) {
            return null;
        }
        String[] headerFields = HEADERS_BODY_PATTERN.split(headersAndBody[0]);
        headerFields = ArrayUtil.dropFromEndWhile(headerFields, "");
        String requestLine = headerFields[0];
        HashMap<String, String> generalHeaders = new HashMap<String, String>();
        for (String string : headerFields) {
            String[] header = HEADER_VALUE_PATTERN.split(string);
            generalHeaders.put(header[0].toLowerCase(), header[1]);
        }
        String[] elements = RESPONSE_LINE_PATTERN.split(requestLine);
        HttpStatus status = null;
        int statusCode = Integer.parseInt(elements[1]);
        for (HttpStatus httpStatus : HttpStatus.values()) {
            if (statusCode == httpStatus.code()) break;
        }
        HttpVersion httpVersion = HttpVersion.fromString(elements[0]);
        buffer.position(headersAndBody[0].length() + 4);
        return new DefaultHttpResponse(httpVersion, status, generalHeaders);
    }
}

