/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http;

import java.nio.ByteBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.http.HttpServerCodec;
import org.apache.mina.http.api.HttpEndOfContent;
import org.apache.mina.http.api.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerEncoder
implements ProtocolEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerCodec.class);
    private static final CharsetEncoder ENCODER = StandardCharsets.UTF_8.newEncoder();

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        LOG.debug("encode {}", (Object)message.getClass().getCanonicalName());
        if (message instanceof HttpResponse) {
            LOG.debug("HttpResponse");
            HttpResponse msg = (HttpResponse)message;
            StringBuilder sb = new StringBuilder(msg.getStatus().line());
            for (Map.Entry<String, String> header : msg.getHeaders().entrySet()) {
                sb.append(header.getKey());
                sb.append(": ");
                sb.append(header.getValue());
                sb.append("\r\n");
            }
            sb.append("\r\n");
            IoBuffer buf = IoBuffer.allocate((int)sb.length()).setAutoExpand(true);
            buf.putString((CharSequence)sb.toString(), ENCODER);
            buf.flip();
            out.write((Object)buf);
        } else if (message instanceof ByteBuffer) {
            LOG.debug("Body {}", message);
            out.write(message);
        } else if (message instanceof HttpEndOfContent) {
            LOG.debug("End of Content");
        }
    }

    public void dispose(IoSession session) throws Exception {
    }
}

