/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.http.api;

import java.util.Map;
import org.apache.mina.http.api.HttpResponse;
import org.apache.mina.http.api.HttpStatus;
import org.apache.mina.http.api.HttpVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpResponse
implements HttpResponse {
    private final HttpVersion version;
    private final HttpStatus status;
    private final Map<String, String> headers;

    public DefaultHttpResponse(HttpVersion version, HttpStatus status, Map<String, String> headers) {
        this.version = version;
        this.status = status;
        this.headers = headers;
    }

    @Override
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public String getContentType() {
        return this.headers.get("content-type");
    }

    @Override
    public boolean isKeepAlive() {
        return false;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public HttpStatus getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP RESPONSE STATUS: ").append((Object)this.status).append('\n');
        sb.append("VERSION: ").append((Object)this.version).append('\n');
        sb.append("-- HEADER --- \n");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            sb.append(entry.getKey()).append(':').append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }
}

