/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.coap;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.api.AbstractIoFutureListener;
import org.apache.mina.api.AbstractIoHandler;
import org.apache.mina.api.IdleStatus;
import org.apache.mina.api.IoFilter;
import org.apache.mina.api.IoFutureListener;
import org.apache.mina.api.IoHandler;
import org.apache.mina.api.IoSession;
import org.apache.mina.coap.CoapCode;
import org.apache.mina.coap.CoapMessage;
import org.apache.mina.coap.CoapOption;
import org.apache.mina.coap.CoapOptionType;
import org.apache.mina.coap.codec.CoapDecoder;
import org.apache.mina.coap.codec.CoapEncoder;
import org.apache.mina.coap.resource.AbstractResourceHandler;
import org.apache.mina.coap.resource.CoapResponse;
import org.apache.mina.coap.resource.ResourceHandler;
import org.apache.mina.coap.resource.ResourceRegistry;
import org.apache.mina.codec.ProtocolDecoder;
import org.apache.mina.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.query.Request;
import org.apache.mina.filter.query.RequestFilter;
import org.apache.mina.transport.bio.BioUdpServer;

public class CoapServer {
    public static void main(String[] args) {
        final ConcurrentHashMap registration = new ConcurrentHashMap();
        final ResourceRegistry reg = new ResourceRegistry();
        reg.register((ResourceHandler)new AbstractResourceHandler(){

            public String getPath() {
                return "demo";
            }

            public CoapResponse handle(CoapMessage request, IoSession session) {
                return new CoapResponse(CoapCode.CONTENT.getCode(), "niah niah niah niah niah\n niah niah niah\n".getBytes(), new CoapOption[]{new CoapOption(CoapOptionType.CONTENT_FORMAT, new byte[]{0})});
            }

            public String getTittle() {
                return "Some demo resource";
            }
        });
        reg.register((ResourceHandler)new AbstractResourceHandler(){

            public CoapResponse handle(CoapMessage request, IoSession session) {
                String device = null;
                try {
                    for (CoapOption o : request.getOptions()) {
                        String qr;
                        if (o.getType() != CoapOptionType.URI_QUERY || !(qr = new String(o.getData(), "UTF-8")).startsWith("id=")) continue;
                        device = qr.substring(2);
                    }
                    if (device != null) {
                        registration.put(device, session);
                        return new CoapResponse(CoapCode.CREATED.getCode(), null, new CoapOption[0]);
                    }
                    return new CoapResponse(CoapCode.BAD_REQUEST.getCode(), "no id=xxx parameter".getBytes("UTF-8"), new CoapOption[0]);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("no UTF-8 in the JVM", e);
                }
            }

            public String getPath() {
                return "register";
            }
        });
        BioUdpServer server = new BioUdpServer();
        final RequestFilter rq = new RequestFilter();
        server.setFilters(new IoFilter[]{new ProtocolCodecFilter((ProtocolEncoder)new CoapEncoder(), (ProtocolDecoder)new CoapDecoder()), rq});
        server.getSessionConfig().setIdleTimeInMillis(IdleStatus.READ_IDLE, 600000L);
        server.setIoHandler((IoHandler)new AbstractIoHandler(){
            long start = System.currentTimeMillis();
            int count = 0;

            public void messageReceived(IoSession session, Object message) {
                System.err.println("rcv : " + message);
                CoapMessage resp = reg.respond((CoapMessage)message, session);
                System.err.println("resp : " + resp);
                session.write((Object)resp);
                ++this.count;
                if (this.count >= 100000) {
                    System.err.println("time for 100k msg : " + (System.currentTimeMillis() - this.start));
                    this.count = 0;
                    this.start = System.currentTimeMillis();
                }
            }

            public void messageSent(IoSession session, Object message) {
                System.err.println("sent : " + message);
            }

            public void sessionIdle(IoSession session, IdleStatus status) {
                System.err.println("idle closing");
                session.close(false);
            }
        });
        try {
            server.bind(5683);
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        for (IoSession s : registration.values()) {
                            rq.request(s, (Request)CoapMessage.get((String)"st", (boolean)true), 15000L).register((IoFutureListener)new AbstractIoFutureListener<CoapMessage>(){

                                public void completed(CoapMessage result) {
                                    System.err.println("status : " + result);
                                }
                            });
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            }.start();
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }
}

