/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.echoserver;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.mina.api.AbstractIoHandler;
import org.apache.mina.api.IoFilter;
import org.apache.mina.api.IoHandler;
import org.apache.mina.api.IoSession;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.nio.NioTcpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioEchoServer {
    private static final Logger LOG = LoggerFactory.getLogger(NioEchoServer.class);

    public static void main(String[] args) {
        LOG.info("starting echo server");
        NioTcpServer acceptor = new NioTcpServer();
        acceptor.setFilters(new IoFilter[]{new LoggingFilter("LoggingFilter1")});
        acceptor.setIoHandler((IoHandler)new AbstractIoHandler(){

            public void sessionOpened(IoSession session) {
                LOG.info("session opened {}", (Object)session);
                String welcomeStr = "welcome\n";
                ByteBuffer bf = ByteBuffer.allocate("welcome\n".length());
                bf.put("welcome\n".getBytes());
                bf.flip();
                session.write((Object)bf);
            }

            public void messageReceived(IoSession session, Object message) {
                if (message instanceof ByteBuffer) {
                    LOG.info("echoing");
                    session.write(message);
                }
            }
        });
        try {
            InetSocketAddress address = new InetSocketAddress(9999);
            acceptor.bind((SocketAddress)address);
            LOG.debug("Running the server for 25 sec");
            Thread.sleep(25000L);
            LOG.debug("Unbinding the TCP port");
            acceptor.unbind();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted exception", (Throwable)e);
        }
    }
}

