/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.tapedeck;

import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.tapedeck.Command;
import org.apache.mina.example.tapedeck.CommandSyntaxException;
import org.apache.mina.example.tapedeck.EjectCommand;
import org.apache.mina.example.tapedeck.InfoCommand;
import org.apache.mina.example.tapedeck.ListCommand;
import org.apache.mina.example.tapedeck.LoadCommand;
import org.apache.mina.example.tapedeck.PauseCommand;
import org.apache.mina.example.tapedeck.PlayCommand;
import org.apache.mina.example.tapedeck.QuitCommand;
import org.apache.mina.example.tapedeck.StopCommand;
import org.apache.mina.statemachine.StateControl;
import org.apache.mina.statemachine.annotation.IoHandlerTransition;
import org.apache.mina.statemachine.annotation.IoHandlerTransitions;
import org.apache.mina.statemachine.annotation.State;
import org.apache.mina.statemachine.context.AbstractStateContext;
import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.event.Event;
import org.apache.mina.statemachine.event.IoHandlerEvents;

public class TapeDeckServer {
    @State
    public static final String ROOT = "Root";
    @State(value="Root")
    public static final String EMPTY = "Empty";
    @State(value="Root")
    public static final String LOADED = "Loaded";
    @State(value="Root")
    public static final String PLAYING = "Playing";
    @State(value="Root")
    public static final String PAUSED = "Paused";
    private final String[] tapes = new String[]{"The Knife - Silent Shout", "Kings of convenience - Riot on an empty street"};

    @IoHandlerTransition(on={IoHandlerEvents.SESSION_OPENED}, in={"Empty"})
    public void connect(IoSession session) {
        session.write((Object)"+ Greetings from your tape deck!");
    }

    @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Empty"}, next="Loaded")
    public void loadTape(TapeDeckContext context, IoSession session, LoadCommand cmd) {
        if (cmd.getTapeNumber() < 1 || cmd.getTapeNumber() > this.tapes.length) {
            session.write((Object)("- Unknown tape number: " + cmd.getTapeNumber()));
            StateControl.breakAndGotoNext((String)EMPTY);
        } else {
            context.tapeName = this.tapes[cmd.getTapeNumber() - 1];
            session.write((Object)("+ \"" + context.tapeName + "\" loaded"));
        }
    }

    @IoHandlerTransitions(value={@IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Loaded"}, next="Playing"), @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Paused"}, next="Playing")})
    public void playTape(TapeDeckContext context, IoSession session, PlayCommand cmd) {
        session.write((Object)("+ Playing \"" + context.tapeName + "\""));
    }

    @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Playing"}, next="Paused")
    public void pauseTape(TapeDeckContext context, IoSession session, PauseCommand cmd) {
        session.write((Object)("+ \"" + context.tapeName + "\" paused"));
    }

    @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Playing"}, next="Loaded")
    public void stopTape(TapeDeckContext context, IoSession session, StopCommand cmd) {
        session.write((Object)("+ \"" + context.tapeName + "\" stopped"));
    }

    @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Loaded"}, next="Empty")
    public void ejectTape(TapeDeckContext context, IoSession session, EjectCommand cmd) {
        session.write((Object)("+ \"" + context.tapeName + "\" ejected"));
        context.tapeName = null;
    }

    @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Root"})
    public void listTapes(IoSession session, ListCommand cmd) {
        StringBuilder response = new StringBuilder("+ (");
        for (int i = 0; i < this.tapes.length; ++i) {
            response.append(i + 1).append(": ");
            response.append('\"').append(this.tapes[i]).append('\"');
            if (i >= this.tapes.length - 1) continue;
            response.append(", ");
        }
        response.append(')');
        session.write((Object)response);
    }

    @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Root"})
    public void info(TapeDeckContext context, IoSession session, InfoCommand cmd) {
        String state = context.getCurrentState().getId().toLowerCase();
        if (context.tapeName == null) {
            session.write((Object)("+ Tape deck is " + state + ""));
        } else {
            session.write((Object)("+ Tape deck is " + state + ". Current tape: \"" + context.tapeName + "\""));
        }
    }

    @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Root"})
    public void quit(TapeDeckContext context, IoSession session, QuitCommand cmd) {
        session.write((Object)"+ Bye! Please come back!").addListener(IoFutureListener.CLOSE);
    }

    @IoHandlerTransition(on={IoHandlerEvents.MESSAGE_RECEIVED}, in={"Root"}, weight=10)
    public void error(Event event, StateContext context, IoSession session, Command cmd) {
        session.write((Object)("- Cannot " + cmd.getName() + " while " + context.getCurrentState().getId().toLowerCase()));
    }

    @IoHandlerTransition(on={IoHandlerEvents.EXCEPTION_CAUGHT}, in={"Root"})
    public void commandSyntaxError(IoSession session, CommandSyntaxException e) {
        session.write((Object)("- " + e.getMessage()));
    }

    @IoHandlerTransition(on={IoHandlerEvents.EXCEPTION_CAUGHT}, in={"Root"}, weight=10)
    public void exceptionCaught(IoSession session, Exception e) {
        e.printStackTrace();
        session.closeNow();
    }

    @IoHandlerTransition(in={"Root"}, weight=100)
    public void unhandledEvent() {
    }

    static class TapeDeckContext
    extends AbstractStateContext {
        private String tapeName;

        TapeDeckContext() {
        }
    }
}

