/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.sumup;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.sumup.ClientSessionHandler;
import org.apache.mina.example.sumup.codec.SumUpProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class Client {
    private static final String HOSTNAME = "localhost";
    private static final int PORT = 8080;
    private static final long CONNECT_TIMEOUT = 30000L;
    private static final boolean USE_CUSTOM_CODEC = true;

    public static void main(String[] args) throws Throwable {
        IoSession session;
        if (args.length == 0) {
            System.out.println("Please specify the list of any integers");
            return;
        }
        int[] values = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = Integer.parseInt(args[i]);
        }
        NioSocketConnector connector = new NioSocketConnector();
        connector.setConnectTimeoutMillis(30000L);
        connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new SumUpProtocolCodecFactory(false)));
        connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        connector.setHandler((IoHandler)new ClientSessionHandler(values));
        while (true) {
            try {
                ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(HOSTNAME, 8080));
                future.awaitUninterruptibly();
                session = future.getSession();
            }
            catch (RuntimeIoException e) {
                System.err.println("Failed to connect.");
                e.printStackTrace();
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
        session.getCloseFuture().awaitUninterruptibly();
        connector.dispose();
    }
}

