/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.test;

import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.example.test.MinaServerHandler;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class MinaServer {
    private static final int PORT = 444;

    public static void main(String[] args) throws Exception {
        System.out.println("server");
        ExecutorFilter executorFilter = new ExecutorFilter(1, 10, 1000L, TimeUnit.SECONDS);
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        DefaultIoFilterChainBuilder filterChain = acceptor.getFilterChain();
        filterChain.addFirst("sslFilter", (IoFilter)MinaServer.addSSLFilter());
        ProtocolCodecFilter protocolCodecFilter = new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(Charset.forName("UTF-8")));
        filterChain.addLast("codec", (IoFilter)protocolCodecFilter);
        filterChain.addLast("threadPool", (IoFilter)executorFilter);
        acceptor.setHandler((IoHandler)new MinaServerHandler());
        acceptor.getSessionConfig().setReadBufferSize(2048);
        acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        acceptor.bind((SocketAddress)new InetSocketAddress(444));
    }

    private static SslFilter addSSLFilter() throws Exception {
        KeyManager[] keyManagers = MinaServer.getKeyManagers();
        TrustManager[] trustManagers = null;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        SslFilter sslFilter = new SslFilter(sslContext);
        sslFilter.setNeedClientAuth(false);
        return sslFilter;
    }

    private static KeyManager[] getKeyManagers() throws Exception {
        char[] keystorePassword = "123456".toCharArray();
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream keystoreFile = new FileInputStream("C:\\git\\commserver\\security\\.keystore");){
            store.load(keystoreFile, keystorePassword);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
        kmf.init(store, keystorePassword);
        return kmf.getKeyManagers();
    }
}

