/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.haiku;

public class PhraseUtilities {
    static int countSyllablesInPhrase(String phrase) {
        int syllables = 0;
        for (String word : phrase.split("[^\\w-]+")) {
            if (word.length() <= 0) continue;
            syllables += PhraseUtilities.countSyllablesInWord(word.toLowerCase());
        }
        return syllables;
    }

    static int countSyllablesInWord(String word) {
        char[] chars = word.toCharArray();
        int syllables = 0;
        boolean lastWasVowel = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (PhraseUtilities.isVowel(c)) {
                if (lastWasVowel && (i <= 0 || !PhraseUtilities.isE(chars, i - 1) || !PhraseUtilities.isO(chars, i))) continue;
                ++syllables;
                lastWasVowel = true;
                continue;
            }
            lastWasVowel = false;
        }
        if (word.endsWith("oned") || word.endsWith("ne") || word.endsWith("ide") || word.endsWith("ve") || word.endsWith("fe") || word.endsWith("nes") || word.endsWith("mes")) {
            --syllables;
        }
        return syllables;
    }

    static boolean isE(char[] chars, int position) {
        return PhraseUtilities.isCharacter(chars, position, 'e');
    }

    static boolean isCharacter(char[] chars, int position, char c) {
        return chars[position] == c;
    }

    static boolean isO(char[] chars, int position) {
        return PhraseUtilities.isCharacter(chars, position, 'o');
    }

    static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }
}

