/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.tapedeck;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.example.tapedeck.CommandDecoder;
import org.apache.mina.example.tapedeck.TapeDeckServer;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.textline.TextLineEncoder;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.statemachine.StateMachine;
import org.apache.mina.statemachine.StateMachineFactory;
import org.apache.mina.statemachine.StateMachineProxyBuilder;
import org.apache.mina.statemachine.annotation.IoHandlerTransition;
import org.apache.mina.statemachine.context.IoSessionStateContextLookup;
import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.context.StateContextFactory;
import org.apache.mina.statemachine.context.StateContextLookup;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class Main {
    private static final int PORT = 12345;

    private static IoHandler createIoHandler() {
        StateMachine sm = StateMachineFactory.getInstance(IoHandlerTransition.class).create("Empty", (Object)new TapeDeckServer());
        return (IoHandler)new StateMachineProxyBuilder().setStateContextLookup((StateContextLookup)new IoSessionStateContextLookup(new StateContextFactory(){

            public StateContext create() {
                return new TapeDeckServer.TapeDeckContext();
            }
        })).create(IoHandler.class, sm);
    }

    public static void main(String[] args) throws Exception {
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        acceptor.setReuseAddress(true);
        ProtocolCodecFilter pcf = new ProtocolCodecFilter((ProtocolEncoder)new TextLineEncoder(), (ProtocolDecoder)new CommandDecoder());
        acceptor.getFilterChain().addLast("log1", (IoFilter)new LoggingFilter("log1"));
        acceptor.getFilterChain().addLast("codec", (IoFilter)pcf);
        acceptor.getFilterChain().addLast("log2", (IoFilter)new LoggingFilter("log2"));
        acceptor.setHandler(Main.createIoHandler());
        acceptor.bind((SocketAddress)new InetSocketAddress(12345));
    }
}

