/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.udp;

import java.net.SocketAddress;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.udp.MemoryMonitor;

public class MemoryMonitorHandler
extends IoHandlerAdapter {
    private MemoryMonitor server;

    public MemoryMonitorHandler(MemoryMonitor server) {
        this.server = server;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message instanceof IoBuffer) {
            IoBuffer buffer = (IoBuffer)message;
            SocketAddress remoteAddress = session.getRemoteAddress();
            this.server.recvUpdate(remoteAddress, buffer.getLong());
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        System.out.println("Session closed...");
        SocketAddress remoteAddress = session.getRemoteAddress();
        this.server.removeClient(remoteAddress);
    }

    public void sessionCreated(IoSession session) throws Exception {
        System.out.println("Session created...");
        SocketAddress remoteAddress = session.getRemoteAddress();
        this.server.addClient(remoteAddress);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        System.out.println("Session idle...");
    }

    public void sessionOpened(IoSession session) throws Exception {
        System.out.println("Session Opened...");
    }
}

