/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.chat;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.chat.ChatCommand;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatProtocolHandler
extends IoHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatProtocolHandler.class);
    private final Set<IoSession> sessions = Collections.synchronizedSet(new HashSet());
    private final Set<String> users = Collections.synchronizedSet(new HashSet());

    public void exceptionCaught(IoSession session, Throwable cause) {
        LOGGER.warn("Unexpected exception.", cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) {
        Logger log = LoggerFactory.getLogger(ChatProtocolHandler.class);
        log.info("received: " + message);
        String theMessage = (String)message;
        String[] result = theMessage.split(" ", 2);
        String theCommand = result[0];
        try {
            ChatCommand command = ChatCommand.valueOf(theCommand);
            String user = (String)session.getAttribute((Object)"user");
            switch (command.toInt()) {
                case 1: {
                    session.write((Object)"QUIT OK");
                    session.close(true);
                    break;
                }
                case 0: {
                    if (user != null) {
                        session.write((Object)("LOGIN ERROR user " + user + " already logged in."));
                        return;
                    }
                    if (result.length != 2) {
                        session.write((Object)"LOGIN ERROR invalid login command.");
                        return;
                    }
                    user = result[1];
                    if (this.users.contains(user)) {
                        session.write((Object)("LOGIN ERROR the name " + user + " is already used."));
                        return;
                    }
                    this.sessions.add(session);
                    session.setAttribute((Object)"user", (Object)user);
                    MdcInjectionFilter.setProperty((IoSession)session, (String)"user", (String)user);
                    this.users.add(user);
                    session.write((Object)"LOGIN OK");
                    this.broadcast("The user " + user + " has joined the chat session.");
                    break;
                }
                case 2: {
                    if (result.length == 2) {
                        this.broadcast(user + ": " + result[1]);
                    }
                    break;
                }
                default: {
                    LOGGER.info("Unhandled command: " + command);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Illegal argument", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(String message) {
        Set<IoSession> set = this.sessions;
        synchronized (set) {
            for (IoSession session : this.sessions) {
                if (!session.isConnected()) continue;
                session.write((Object)("BROADCAST OK " + message));
            }
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        String user = (String)session.getAttribute((Object)"user");
        this.users.remove(user);
        this.sessions.remove(session);
        this.broadcast("The user " + user + " has left the chat session.");
    }

    public boolean isChatUser(String name) {
        return this.users.contains(name);
    }

    public int getNumberOfUsers() {
        return this.users.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kick(String name) {
        Set<IoSession> set = this.sessions;
        synchronized (set) {
            for (IoSession session : this.sessions) {
                if (!name.equals(session.getAttribute((Object)"user"))) continue;
                session.close(true);
                break;
            }
        }
    }
}

