/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.echoserver;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoProtocolHandler
extends IoHandlerAdapter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void sessionCreated(IoSession session) {
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
        session.setAttribute((Object)SslFilter.USE_NOTIFICATION);
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.logger.info("CLOSED");
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.logger.info("OPENED");
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        this.logger.info("*** IDLE #" + session.getIdleCount(IdleStatus.BOTH_IDLE) + " ***");
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        this.logger.info("Received : " + message);
        session.write((Object)((IoBuffer)message).duplicate());
    }
}

