/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.proxy;

import java.net.SocketAddress;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.TrafficMask;
import org.apache.mina.example.proxy.AbstractProxyIoHandler;
import org.apache.mina.example.proxy.ServerToProxyIoHandler;

public class ClientToProxyIoHandler
extends AbstractProxyIoHandler {
    private final ServerToProxyIoHandler connectorHandler = new ServerToProxyIoHandler();
    private final IoConnector connector;
    private final SocketAddress remoteAddress;

    public ClientToProxyIoHandler(IoConnector connector, SocketAddress remoteAddress) {
        this.connector = connector;
        this.remoteAddress = remoteAddress;
        connector.setHandler((IoHandler)this.connectorHandler);
    }

    public void sessionOpened(final IoSession session) throws Exception {
        this.connector.connect(this.remoteAddress).addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ConnectFuture future) {
                try {
                    future.getSession().setAttribute((Object)AbstractProxyIoHandler.OTHER_IO_SESSION, (Object)session);
                    session.setAttribute((Object)AbstractProxyIoHandler.OTHER_IO_SESSION, (Object)future.getSession());
                    future.getSession().setTrafficMask(TrafficMask.ALL);
                }
                catch (RuntimeIoException e) {
                    session.close();
                }
                finally {
                    session.setTrafficMask(TrafficMask.ALL);
                }
            }
        });
    }
}

