/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.echoserver;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.example.echoserver.EchoProtocolHandler;
import org.apache.mina.example.echoserver.ssl.BogusSslContextFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class Main {
    private static final int PORT = 8080;
    private static final boolean USE_SSL = false;

    public static void main(String[] args) throws Exception {
        NioSocketAcceptor acceptor = new NioSocketAcceptor();
        DefaultIoFilterChainBuilder chain = acceptor.getFilterChain();
        acceptor.setHandler((IoHandler)new EchoProtocolHandler());
        acceptor.bind((SocketAddress)new InetSocketAddress(8080));
        System.out.println("Listening on port 8080");
        while (true) {
            System.out.println("R: " + acceptor.getReadBytesThroughput() + ", W: " + acceptor.getWrittenBytesThroughput());
            Thread.sleep(3000L);
        }
    }

    private static void addSSLSupport(DefaultIoFilterChainBuilder chain) throws Exception {
        SslFilter sslFilter = new SslFilter(BogusSslContextFactory.getInstance(true));
        chain.addLast("sslFilter", (IoFilter)sslFilter);
        System.out.println("SSL ON");
    }

    private static void addLogger(DefaultIoFilterChainBuilder chain) throws Exception {
        chain.addLast("logger", (IoFilter)new LoggingFilter());
        System.out.println("Logging ON");
    }
}

