/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.chat.client;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.chat.ChatCommand;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;

public class SwingChatClientHandler
extends IoHandlerAdapter {
    private static final IoFilter LOGGING_FILTER = new LoggingFilter();
    private static final IoFilter CODEC_FILTER = new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory());
    private final Callback callback;

    public SwingChatClientHandler(Callback callback) {
        this.callback = callback;
    }

    public void sessionCreated(IoSession session) throws Exception {
        session.getFilterChain().addLast("codec", CODEC_FILTER);
        session.getFilterChain().addLast("logger", LOGGING_FILTER);
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.callback.connected();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        String theMessage = (String)message;
        String[] result = theMessage.split(" ", 3);
        String status = result[1];
        String theCommand = result[0];
        ChatCommand command = ChatCommand.valueOf(theCommand);
        if ("OK".equals(status)) {
            switch (command.toInt()) {
                case 2: {
                    if (result.length != 3) break;
                    this.callback.messageReceived(result[2]);
                    break;
                }
                case 0: {
                    this.callback.loggedIn();
                    break;
                }
                case 1: {
                    this.callback.loggedOut();
                }
            }
        } else if (result.length == 3) {
            this.callback.error(result[2]);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.callback.disconnected();
    }

    public static interface Callback {
        public void connected();

        public void loggedIn();

        public void loggedOut();

        public void disconnected();

        public void messageReceived(String var1);

        public void error(String var1);
    }
}

