/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.udp.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoBuffer;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.NioDatagramConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemMonClient
extends IoHandlerAdapter {
    private Logger log = LoggerFactory.getLogger(MemMonClient.class);
    private IoSession session;
    private IoConnector connector;

    public MemMonClient() {
        this.log.debug("UDPClient::UDPClient");
        this.log.debug("Created a datagram connector");
        this.connector = new NioDatagramConnector();
        this.log.debug("Setting the handler");
        this.connector.setHandler((IoHandler)this);
        this.log.debug("About to connect to the server...");
        ConnectFuture connFuture = this.connector.connect((SocketAddress)new InetSocketAddress("localhost", 18567));
        this.log.debug("About to wait.");
        connFuture.awaitUninterruptibly();
        this.log.debug("Adding a future listener.");
        connFuture.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                if (future.isConnected()) {
                    MemMonClient.this.log.debug("...connected");
                    MemMonClient.this.session = future.getSession();
                    try {
                        MemMonClient.this.sendData();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    MemMonClient.this.log.error("Not connected...exiting");
                }
            }
        });
    }

    private void sendData() throws InterruptedException {
        for (int i = 0; i < 30; ++i) {
            long free = Runtime.getRuntime().freeMemory();
            IoBuffer buffer = IoBuffer.allocate((int)8);
            buffer.putLong(free);
            buffer.flip();
            this.session.write((Object)buffer);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new InterruptedException(e.getMessage());
            }
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        this.log.debug("Session recv...");
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        this.log.debug("Message sent...");
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.log.debug("Session closed...");
    }

    public void sessionCreated(IoSession session) throws Exception {
        this.log.debug("Session created...");
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.log.debug("Session idle...");
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.log.debug("Session opened...");
    }

    public static void main(String[] args) {
        new MemMonClient();
    }
}

