/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.sumup;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.sumup.message.AddMessage;
import org.apache.mina.example.sumup.message.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionHandler
extends IoHandlerAdapter {
    private static final String SUM_KEY = "sum";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void sessionOpened(IoSession session) {
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 60);
        session.setAttribute((Object)SUM_KEY, (Object)new Integer(0));
    }

    public void messageReceived(IoSession session, Object message) {
        int value;
        AddMessage am = (AddMessage)message;
        int sum = (Integer)session.getAttribute((Object)SUM_KEY);
        long expectedSum = (long)sum + (long)(value = am.getValue());
        if (expectedSum > Integer.MAX_VALUE || expectedSum < Integer.MIN_VALUE) {
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(false);
            session.write((Object)rm);
        } else {
            sum = (int)expectedSum;
            session.setAttribute((Object)SUM_KEY, (Object)new Integer(sum));
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(true);
            rm.setValue(sum);
            session.write((Object)rm);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        this.logger.info("Disconnecting the idle.");
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }
}

