/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.httpserver.codec;

import java.util.Map;

public class HttpRequestMessage {
    private Map headers = null;

    public void setHeaders(Map headers) {
        this.headers = headers;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public String getContext() {
        String[] context = (String[])this.headers.get("Context");
        return context == null ? "" : context[0];
    }

    public String getParameter(String name) {
        String[] param = (String[])this.headers.get("@".concat(name));
        return param == null ? "" : param[0];
    }

    public String[] getParameters(String name) {
        String[] param = (String[])this.headers.get("@".concat(name));
        return param == null ? new String[]{} : param;
    }

    public String[] getHeader(String name) {
        return (String[])this.headers.get(name);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry e : this.headers.entrySet()) {
            str.append(e.getKey() + " : " + HttpRequestMessage.arrayToString((String[])e.getValue(), ',') + "\n");
        }
        return str.toString();
    }

    public static String arrayToString(String[] s, char sep) {
        if (s == null || s.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (s != null) {
            for (int i = 0; i < s.length; ++i) {
                if (i > 0) {
                    buf.append(sep);
                }
                buf.append(s[i]);
            }
        }
        return buf.toString();
    }
}

