/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.sumup;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.sumup.message.AddMessage;
import org.apache.mina.example.sumup.message.ResultMessage;
import org.apache.mina.util.SessionLog;

public class ServerSessionHandler
extends IoHandlerAdapter {
    public void sessionOpened(IoSession session) {
        session.setIdleTime(IdleStatus.BOTH_IDLE, 60);
        session.setAttachment((Object)new Integer(0));
    }

    public void messageReceived(IoSession session, Object message) {
        int value;
        AddMessage am = (AddMessage)message;
        int sum = (Integer)session.getAttachment();
        long expectedSum = (long)sum + (long)(value = am.getValue());
        if (expectedSum > Integer.MAX_VALUE || expectedSum < Integer.MIN_VALUE) {
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(false);
            session.write((Object)rm);
        } else {
            sum = (int)expectedSum;
            session.setAttachment((Object)new Integer(sum));
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(true);
            rm.setValue(sum);
            session.write((Object)rm);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        SessionLog.info((IoSession)session, (String)"Disconnecting the idle.");
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }
}

