/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.echoserver.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import org.apache.mina.example.echoserver.ssl.BogusSSLContextFactory;

public class SSLSocketFactory
extends SocketFactory {
    private static boolean sslEnabled = false;
    private static javax.net.ssl.SSLSocketFactory sslFactory = null;
    private static SocketFactory factory = null;

    public Socket createSocket(String arg1, int arg2) throws IOException, UnknownHostException {
        if (SSLSocketFactory.isSslEnabled()) {
            return this.getSSLFactory().createSocket(arg1, arg2);
        }
        return new Socket(arg1, arg2);
    }

    public Socket createSocket(String arg1, int arg2, InetAddress arg3, int arg4) throws IOException, UnknownHostException {
        if (SSLSocketFactory.isSslEnabled()) {
            return this.getSSLFactory().createSocket(arg1, arg2, arg3, arg4);
        }
        return new Socket(arg1, arg2, arg3, arg4);
    }

    public Socket createSocket(InetAddress arg1, int arg2) throws IOException {
        if (SSLSocketFactory.isSslEnabled()) {
            return this.getSSLFactory().createSocket(arg1, arg2);
        }
        return new Socket(arg1, arg2);
    }

    public Socket createSocket(InetAddress arg1, int arg2, InetAddress arg3, int arg4) throws IOException {
        if (SSLSocketFactory.isSslEnabled()) {
            return this.getSSLFactory().createSocket(arg1, arg2, arg3, arg4);
        }
        return new Socket(arg1, arg2, arg3, arg4);
    }

    public static SocketFactory getSocketFactory() {
        if (factory == null) {
            factory = new SSLSocketFactory();
        }
        return factory;
    }

    private javax.net.ssl.SSLSocketFactory getSSLFactory() {
        if (sslFactory == null) {
            try {
                sslFactory = BogusSSLContextFactory.getInstance(false).getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("could not create SSL socket", e);
            }
        }
        return sslFactory;
    }

    public static boolean isSslEnabled() {
        return sslEnabled;
    }

    public static void setSslEnabled(boolean newSslEnabled) {
        sslEnabled = newSslEnabled;
    }
}

