/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.chat.client;

import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.example.echoserver.ssl.BogusSSLContextFactory;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;

public class ChatClientSupport {
    private final IoHandler handler;
    private final String name;
    private IoSession session;

    public ChatClientSupport(String name, IoHandler handler) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        this.name = name;
        this.handler = handler;
    }

    public boolean connect(SocketConnector connector, SocketAddress address, boolean useSsl) {
        if (this.session != null && this.session.isConnected()) {
            throw new IllegalStateException("Already connected. Disconnect first.");
        }
        try {
            SocketConnectorConfig config = new SocketConnectorConfig();
            if (useSsl) {
                SSLContext sslContext = BogusSSLContextFactory.getInstance(false);
                SSLFilter sslFilter = new SSLFilter(sslContext);
                sslFilter.setUseClientMode(true);
                config.getFilterChain().addLast("sslFilter", (IoFilter)sslFilter);
            }
            ConnectFuture future1 = connector.connect(address, this.handler, (IoServiceConfig)config);
            future1.join();
            if (!future1.isConnected()) {
                return false;
            }
            this.session = future1.getSession();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void login() {
        this.session.write((Object)("LOGIN " + this.name));
    }

    public void broadcast(String message) {
        this.session.write((Object)("BROADCAST " + message));
    }

    public void quit() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                this.session.write((Object)"QUIT");
                this.session.getCloseFuture().join();
            }
            this.session.close();
        }
    }
}

