/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.echoserver;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.example.echoserver.EchoProtocolHandler;
import org.apache.mina.example.echoserver.ssl.BogusSSLContextFactory;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class Main {
    private static final int PORT = 8080;
    private static final boolean USE_SSL = false;

    public static void main(String[] args) throws Exception {
        SocketAcceptor acceptor = new SocketAcceptor();
        SocketAcceptorConfig config = new SocketAcceptorConfig();
        DefaultIoFilterChainBuilder chain = config.getFilterChain();
        Main.addLogger(chain);
        acceptor.bind((SocketAddress)new InetSocketAddress(8080), (IoHandler)new EchoProtocolHandler(), (IoServiceConfig)config);
        System.out.println("Listening on port 8080");
    }

    private static void addSSLSupport(DefaultIoFilterChainBuilder chain) throws Exception {
        SSLFilter sslFilter = new SSLFilter(BogusSSLContextFactory.getInstance(true));
        chain.addLast("sslFilter", (IoFilter)sslFilter);
        System.out.println("SSL ON");
    }

    private static void addLogger(DefaultIoFilterChainBuilder chain) throws Exception {
        chain.addLast("logger", (IoFilter)new LoggingFilter());
        System.out.println("Logging ON");
    }
}

