/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.coap;

public enum CoapCode {
    GET("GET", 1),
    POST("POST", 2),
    PUT("PUT", 3),
    DELETE("DELETE", 4),
    CREATED("2.01", 65),
    DELETED("2.02", 66),
    VALID("2.03", 67),
    CHANGED("2.04", 68),
    CONTENT("2.05", 69),
    BAD_REQUEST("4.00", 128),
    UNAUTHORIZED("4.01", 129),
    BAD_OPTION("4.02", 130),
    FORBIDDEN("4.03", 131),
    NOT_FOUND("4.04", 132),
    METHOD_NOT_ALLOWED("4.05", 133),
    NOT_ACCEPTABLE("4.06", 134),
    PRECONDITION_FAILED("4.12", 140),
    REQUEST_ENTITY_TOO_LARGE("4.13", 141),
    UNSUPPORTED_CONTENT_FORMAT("4.15", 143),
    INTERNAL_SERVER_ERROR("5.00", 160),
    NOT_IMPLEMENTED("5.01", 161),
    BAD_GATEWAY("5.02", 162),
    SERVICE_UNAVAILABLE("5.03", 163),
    GATEWAY_TIMEOUT("5.04", 164),
    PROXYING_NOT_SUPPORTED("5.05", 165);

    private final String text;
    private final int code;

    private CoapCode(String text, int code) {
        this.text = text;
        this.code = code;
    }

    public String getText() {
        return this.text;
    }

    public int getCode() {
        return this.code;
    }

    public static CoapCode fromCode(int code) {
        for (CoapCode t : CoapCode.values()) {
            if (t.getCode() != code) continue;
            return t;
        }
        return null;
    }
}

