/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http.fixture;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final String targetPath;
    private final int code;
    private final int maxRedirects;
    private int redirectCount = 0;
    private final String myPath;

    public RedirectionServlet(int code, String targetPath) {
        this.code = code;
        this.targetPath = targetPath;
        this.maxRedirects = 1;
        this.myPath = null;
    }

    public RedirectionServlet(int code, String myPath, String targetPath, int maxRedirects) {
        this.code = code;
        this.myPath = myPath;
        this.targetPath = targetPath;
        this.maxRedirects = maxRedirects;
    }

    public int getRedirectCount() {
        return this.redirectCount;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ++this.redirectCount;
        if (this.myPath == null) {
            resp.setStatus(this.code);
            resp.setHeader("Location", this.targetPath);
        } else if (this.maxRedirects < 0) {
            resp.setStatus(this.code);
            resp.setHeader("Location", this.myPath);
        } else if (this.redirectCount <= this.maxRedirects) {
            resp.setStatus(this.code);
            resp.setHeader("Location", this.myPath + "/" + this.redirectCount);
        } else {
            resp.setStatus(this.code);
            resp.setHeader("Location", this.targetPath);
        }
    }
}

