/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.knownhost;

import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.ssh.SshWagon;
import org.apache.maven.wagon.providers.ssh.TestData;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostChangedException;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostsProvider;
import org.apache.maven.wagon.providers.ssh.knownhost.SingleKnownHostProvider;
import org.apache.maven.wagon.providers.ssh.knownhost.UnknownHostException;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusTestCase;

public class KnownHostsProviderTestCase
extends PlexusTestCase {
    protected KnownHostsProvider okHostsProvider;
    protected KnownHostsProvider failHostsProvider;
    protected KnownHostsProvider changedHostsProvider;
    private SshWagon wagon;
    private Repository source;
    private static final String CORRECT_KEY = TestData.getHostKey();
    private static final String CHANGED_KEY = "AAAAB3NzaC1yc2EAAAABIwAAAQEA8VLKkfHl2CNqW+m0603z07dyweWzzdVGQlMPUX4z1264E7M/h+6lPKiOo+u49CL7eQVA+FtWTZoJ3oBAMABcKnHx41TnSpQUkbdR6rzyC6IG1lXiVtEjG2w7DUnxpCtVo5PaQuJobwoXv5NNL3vx03THPgcDJquLPWvGnDWhnXoEh3/6c7rprwT+PrjZ6LIT35ZCUGajoehhF151oNbFMQHllfR6EAiZIP0z0nIVI+Jiv6g+XZapumVPVYjdOfxvLKQope1H9HJamT3bDIm8mkebUB10DzQJYxFt4/0wiNH3L4jsIFn+CiW1/IQm5yyff1CUO87OqVbtp9BlaXZNmw==";

    public void testIncorrectKey() throws Exception {
        this.wagon.setKnownHostsProvider(this.failHostsProvider);
        try {
            this.wagon.connect(this.source);
            KnownHostsProviderTestCase.fail((String)"Should not have successfully connected - host is not known");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void testChangedKey() throws Exception {
        this.wagon.setKnownHostsProvider(this.changedHostsProvider);
        try {
            this.wagon.connect(this.source);
            KnownHostsProviderTestCase.fail((String)"Should not have successfully connected - host is changed");
        }
        catch (KnownHostChangedException knownHostChangedException) {
            // empty catch block
        }
    }

    public void testCorrectKey() throws Exception {
        this.wagon.setKnownHostsProvider(this.okHostsProvider);
        this.wagon.connect(this.source);
        KnownHostsProviderTestCase.assertTrue((boolean)true);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.source = new Repository("test", "scp://" + TestData.getUserName() + "@" + TestData.getHostname() + "/tmp/foo");
        this.wagon = (SshWagon)this.lookup(Wagon.ROLE, "scp");
        this.wagon.setInteractive(false);
        this.okHostsProvider = new SingleKnownHostProvider(TestData.getHostname(), CORRECT_KEY);
        this.failHostsProvider = new SingleKnownHostProvider("beaver.codehaus.org", CORRECT_KEY);
        this.changedHostsProvider = new SingleKnownHostProvider(TestData.getHostname(), CHANGED_KEY);
    }
}

