/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.wagon.StreamingWagonTestCase;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.providers.ssh.SshServerEmbedded;
import org.apache.maven.wagon.providers.ssh.TestData;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractEmbeddedScpWagonWithKeyTest
extends StreamingWagonTestCase {
    SshServerEmbedded sshServerEmbedded;

    protected void setUp() throws Exception {
        super.setUp();
        String sshKeyResource = "ssh-keys/id_rsa.pub";
        this.sshServerEmbedded = new SshServerEmbedded(this.getProtocol(), Arrays.asList(sshKeyResource), true);
        this.sshServerEmbedded.start();
        System.out.println("sshd on port " + this.sshServerEmbedded.getPort());
    }

    protected void tearDownWagonTestingFixtures() throws Exception {
        this.sshServerEmbedded.stop();
    }

    protected abstract String getProtocol();

    protected int getTestRepositoryPort() {
        return this.sshServerEmbedded.getPort();
    }

    public String getTestRepositoryUrl() {
        return TestData.getTestRepositoryUrl(this.sshServerEmbedded.getPort());
    }

    protected AuthenticationInfo getAuthInfo() {
        AuthenticationInfo authInfo = super.getAuthInfo();
        authInfo.setUserName("guest");
        authInfo.setPrivateKey(new File("src/test/ssh-keys/id_rsa").getPath());
        return authInfo;
    }

    protected long getExpectedLastModifiedOnGet(Repository repository, Resource resource) {
        return new File(repository.getBasedir(), resource.getName()).lastModified();
    }

    public void testConnect() throws Exception {
        this.getWagon().connect(new Repository("foo", this.getTestRepositoryUrl()), this.getAuthInfo());
        AbstractEmbeddedScpWagonWithKeyTest.assertTrue((boolean)true);
    }

    protected boolean supportsGetIfNewer() {
        return false;
    }

    public void testWithSpaces() throws Exception {
        String dir = "foo   test";
        File spaceDirectory = new File(TestData.getRepoPath(), dir);
        if (spaceDirectory.exists()) {
            FileUtils.deleteDirectory((File)spaceDirectory);
        }
        spaceDirectory.mkdirs();
        String subDir = "foo bar";
        File sub = new File(spaceDirectory, subDir);
        if (sub.exists()) {
            FileUtils.deleteDirectory((File)sub);
        }
        sub.mkdirs();
        File dummy = new File("src/test/resources/dummy.txt");
        FileUtils.copyFileToDirectory((File)dummy, (File)sub);
        String url = this.getTestRepositoryUrl() + "/" + dir;
        Repository repo = new Repository("foo", url);
        Wagon wagon = this.getWagon();
        wagon.connect(repo, this.getAuthInfo());
        List files = wagon.getFileList(subDir);
        AbstractEmbeddedScpWagonWithKeyTest.assertNotNull((Object)files);
        AbstractEmbeddedScpWagonWithKeyTest.assertEquals((int)1, (int)files.size());
        AbstractEmbeddedScpWagonWithKeyTest.assertTrue((boolean)files.contains("dummy.txt"));
        wagon.put(new File("src/test/resources/dummy.txt"), subDir + "/newdummy.txt");
        files = wagon.getFileList(subDir);
        AbstractEmbeddedScpWagonWithKeyTest.assertNotNull((Object)files);
        AbstractEmbeddedScpWagonWithKeyTest.assertEquals((int)2, (int)files.size());
        AbstractEmbeddedScpWagonWithKeyTest.assertTrue((boolean)files.contains("dummy.txt"));
        AbstractEmbeddedScpWagonWithKeyTest.assertTrue((boolean)files.contains("newdummy.txt"));
        File sourceWithSpace = new File("target/directory with spaces");
        if (sourceWithSpace.exists()) {
            FileUtils.deleteDirectory((File)sourceWithSpace);
        }
        File resources = new File("src/test/resources");
        FileUtils.copyDirectory((File)resources, (File)sourceWithSpace);
        wagon.putDirectory(sourceWithSpace, "target with spaces");
        files = wagon.getFileList("target with spaces");
        AbstractEmbeddedScpWagonWithKeyTest.assertNotNull((Object)files);
        AbstractEmbeddedScpWagonWithKeyTest.assertTrue((boolean)files.contains("dummy.txt"));
        AbstractEmbeddedScpWagonWithKeyTest.assertFalse((boolean)files.contains("newdummy.txt"));
        AbstractEmbeddedScpWagonWithKeyTest.assertTrue((boolean)files.contains("log4j.xml"));
    }
}

