/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import org.apache.mina.util.Base64;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.codehaus.plexus.util.IOUtil;

public class TestPublickeyAuthenticator
implements PublickeyAuthenticator {
    private List<PublickeyAuthenticatorRequest> publickeyAuthenticatorRequests = new ArrayList<PublickeyAuthenticatorRequest>();
    private boolean keyAuthz;
    private byte[] bytes;
    private int pos;

    public TestPublickeyAuthenticator(boolean keyAuthz) {
        this.keyAuthz = keyAuthz;
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        boolean bl;
        if (!this.keyAuthz) {
            return false;
        }
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream("ssh-keys/id_rsa.pub");
            PublicKey publicKey = this.decodePublicKey(IOUtil.toString((InputStream)in));
            in.close();
            in = null;
            this.publickeyAuthenticatorRequests.add(new PublickeyAuthenticatorRequest(username, key));
            bl = ((RSAPublicKey)publicKey).getModulus().equals(((RSAPublicKey)publicKey).getModulus());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
        return bl;
    }

    public static byte[] decrypt(byte[] text, PrivateKey key) throws Exception {
        byte[] dectyptedText = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        dectyptedText = cipher.doFinal(text);
        return dectyptedText;
    }

    public PublicKey decodePublicKey(String keyLine) throws Exception {
        this.bytes = null;
        this.pos = 0;
        for (String part : keyLine.split(" ")) {
            if (!part.startsWith("AAAA")) continue;
            this.bytes = Base64.decodeBase64((byte[])part.getBytes());
            break;
        }
        if (this.bytes == null) {
            throw new IllegalArgumentException("no Base64 part to decode");
        }
        String type = this.decodeType();
        if (type.equals("ssh-rsa")) {
            BigInteger e = this.decodeBigInt();
            BigInteger m = this.decodeBigInt();
            RSAPublicKeySpec spec = new RSAPublicKeySpec(m, e);
            return KeyFactory.getInstance("RSA").generatePublic(spec);
        }
        if (type.equals("ssh-dss")) {
            BigInteger p = this.decodeBigInt();
            BigInteger q = this.decodeBigInt();
            BigInteger g = this.decodeBigInt();
            BigInteger y = this.decodeBigInt();
            DSAPublicKeySpec spec = new DSAPublicKeySpec(y, p, q, g);
            return KeyFactory.getInstance("DSA").generatePublic(spec);
        }
        throw new IllegalArgumentException("unknown type " + type);
    }

    private String decodeType() {
        int len = this.decodeInt();
        String type = new String(this.bytes, this.pos, len);
        this.pos += len;
        return type;
    }

    private int decodeInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    private BigInteger decodeBigInt() {
        int len = this.decodeInt();
        byte[] bigIntBytes = new byte[len];
        System.arraycopy(this.bytes, this.pos, bigIntBytes, 0, len);
        this.pos += len;
        return new BigInteger(bigIntBytes);
    }

    public static class PublickeyAuthenticatorRequest {
        private String username;
        private PublicKey publicKey;

        public PublickeyAuthenticatorRequest(String username, PublicKey publicKey) {
            this.username = username;
            this.publicKey = publicKey;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PublickeyAuthenticatorRequest");
            sb.append("{username='").append(this.username).append('\'');
            sb.append(", publicKey=").append(this.publicKey);
            sb.append('}');
            return sb.toString();
        }
    }
}

