/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ShellCommand
implements Command {
    protected static final int OK = 0;
    protected static final int WARNING = 1;
    protected static final int ERROR = 2;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private Thread thread;
    private String commandLine;

    public ShellCommand(String commandLine) {
        this.commandLine = commandLine;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Environment env) throws IOException {
        File tmpFile = File.createTempFile("wagon", "test-sh");
        tmpFile.deleteOnExit();
        int exitValue = 0;
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        try {
            FileUtils.fileWrite((File)tmpFile, (String)this.commandLine);
            Commandline cl = new Commandline();
            cl.setExecutable("/bin/sh");
            cl.createArg().setFile(tmpFile);
            exitValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
            System.out.println("exit value " + exitValue);
        }
        catch (Exception e) {
            exitValue = 2;
            e.printStackTrace();
        }
        finally {
            this.deleteQuietly(tmpFile);
            if (exitValue != 0) {
                this.err.write(stderr.getOutput().getBytes());
                this.err.write(10);
                this.err.flush();
                this.callback.onExit(exitValue, stderr.getOutput());
            } else {
                this.out.write(stdout.getOutput().getBytes());
                this.out.write(10);
                this.out.flush();
                this.callback.onExit(exitValue, stdout.getOutput());
            }
        }
        this.out.flush();
    }

    public void destroy() {
    }

    private void deleteQuietly(File f) {
        try {
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

