/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.TestSuite;

final class TestNGXmlTestSuite
extends TestSuite {
    private final List<File> suiteFiles;
    private List<String> suiteFilePaths;
    private final String testSourceDirectory;
    private final Map<String, String> options;
    private final File reportsDirectory;
    private final int skipAfterFailureCount;

    TestNGXmlTestSuite(List<File> suiteFiles, String testSourceDirectory, Map<String, String> confOptions, File reportsDirectory, int skipAfterFailureCount) {
        this.suiteFiles = suiteFiles;
        this.options = confOptions;
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
        this.skipAfterFailureCount = skipAfterFailureCount;
    }

    void execute(TestNGReporter testNGReporter) throws TestSetFailedException {
        if (this.suiteFilePaths == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        this.startTestSuite(testNGReporter.getRunListener());
        TestNGExecutor.run(this.suiteFilePaths, this.testSourceDirectory, this.options, testNGReporter, this.reportsDirectory, this.skipAfterFailureCount);
        this.finishTestSuite(testNGReporter.getRunListener());
    }

    Iterable locateTestSets() throws TestSetFailedException {
        if (this.suiteFilePaths != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        if (this.suiteFiles.isEmpty()) {
            throw new IllegalStateException("No suite files were specified");
        }
        this.suiteFilePaths = new ArrayList<String>(this.suiteFiles.size());
        ArrayList<File> testSets = new ArrayList<File>(this.suiteFiles.size());
        for (File suiteFile : this.suiteFiles) {
            if (!suiteFile.isFile()) {
                throw new TestSetFailedException("Suite file " + suiteFile + " is not a valid file");
            }
            testSets.add(suiteFile);
            this.suiteFilePaths.add(suiteFile.getAbsolutePath());
        }
        return testSets;
    }

    @Override
    Map<String, String> getOptions() {
        return this.options;
    }
}

