/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testng.TestNGReporter;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testng.conf.TestNG4751Configurator;
import org.apache.maven.surefire.testng.conf.TestNG52Configurator;
import org.apache.maven.surefire.testng.conf.TestNGMapConfigurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.TestNG;

public class TestNGExecutor {
    static /* synthetic */ Class class$org$apache$maven$surefire$report$ReporterManager;
    static /* synthetic */ Class class$org$apache$maven$surefire$suite$SurefireTestSuite;
    static /* synthetic */ Class class$org$testng$IReporter;

    private TestNGExecutor() {
    }

    public static void run(Class[] testClasses, String testSourceDirectory, Map options, ArtifactVersion version, String classifier, ReporterManager reportManager, SurefireTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        TestNG testng = new TestNG(false);
        Configurator configurator = TestNGExecutor.getConfigurator(version);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, classifier, reportManager, suite, reportsDirectory);
        testng.setTestClasses(testClasses);
        testng.run();
    }

    public static void run(List suiteFiles, String testSourceDirectory, Map options, ArtifactVersion version, String classifier, ReporterManager reportManager, SurefireTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        TestNG testng = new TestNG(false);
        Configurator configurator = TestNGExecutor.getConfigurator(version);
        configurator.configure(testng, options);
        TestNGExecutor.postConfigure(testng, testSourceDirectory, classifier, reportManager, suite, reportsDirectory);
        testng.setTestSuites(suiteFiles);
        testng.run();
    }

    private static Configurator getConfigurator(ArtifactVersion version) throws TestSetFailedException {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,5.1]");
            if (range.containsVersion(version)) {
                return new TestNG4751Configurator();
            }
            range = VersionRange.createFromVersionSpec((String)"[5.2]");
            if (range.containsVersion(version)) {
                return new TestNG52Configurator();
            }
            range = VersionRange.createFromVersionSpec((String)"[5.3,)");
            if (range.containsVersion(version)) {
                return new TestNGMapConfigurator();
            }
            throw new TestSetFailedException("Unknown TestNG version " + version);
        }
        catch (InvalidVersionSpecificationException invsex) {
            throw new TestSetFailedException("Bug in plugin. Please report it with the attached stacktrace", (Throwable)invsex);
        }
    }

    private static void postConfigure(TestNG testNG, String sourcePath, String classifier, ReporterManager reportManager, SurefireTestSuite suite, File reportsDirectory) throws TestSetFailedException {
        testNG.setVerbose(0);
        TestNGReporter reporter = TestNGExecutor.createTestNGReporter(reportManager, suite);
        testNG.addListener((Object)reporter);
        TestNGExecutor.attachNonStandardReporter(testNG, "org.testng.reporters.XMLReporter");
        TestNGExecutor.attachNonStandardReporter(testNG, "org.testng.reporters.FailedReporter");
        if (sourcePath != null) {
            testNG.setSourcePath(sourcePath);
        }
        testNG.setOutputDirectory(reportsDirectory.getAbsolutePath());
    }

    private static TestNGReporter createTestNGReporter(ReporterManager reportManager, SurefireTestSuite suite) {
        try {
            Class.forName("org.testng.internal.IResultListener");
            Class<?> c = Class.forName("org.apache.maven.surefire.testng.ConfigurationAwareTestNGReporter");
            try {
                Constructor<?> ctor = c.getConstructor(class$org$apache$maven$surefire$report$ReporterManager == null ? (class$org$apache$maven$surefire$report$ReporterManager = TestNGExecutor.class$("org.apache.maven.surefire.report.ReporterManager")) : class$org$apache$maven$surefire$report$ReporterManager, class$org$apache$maven$surefire$suite$SurefireTestSuite == null ? (class$org$apache$maven$surefire$suite$SurefireTestSuite = TestNGExecutor.class$("org.apache.maven.surefire.suite.SurefireTestSuite")) : class$org$apache$maven$surefire$suite$SurefireTestSuite);
                return (TestNGReporter)ctor.newInstance(reportManager, suite);
            }
            catch (Exception e) {
                throw new RuntimeException("Bug in ConfigurationAwareTestNGReporter", e);
            }
        }
        catch (ClassNotFoundException e) {
            return new TestNGReporter(reportManager);
        }
    }

    private static void attachNonStandardReporter(TestNG testNG, String className) {
        try {
            Class<?> c = Class.forName(className);
            if ((class$org$testng$IReporter == null ? (class$org$testng$IReporter = TestNGExecutor.class$("org.testng.IReporter")) : class$org$testng$IReporter).isAssignableFrom(c)) {
                testNG.addListener(c.newInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

