/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.suite.AbstractDirectoryTestSuite;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestNGTestSet;
import org.apache.maven.surefire.testset.SurefireTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;

public class TestNGDirectoryTestSuite
extends AbstractDirectoryTestSuite {
    private ArtifactVersion version;
    private String classifier;
    private Map options;
    private String testSourceDirectory;
    private File reportsDirectory;
    static /* synthetic */ Class class$junit$framework$Test;

    public TestNGDirectoryTestSuite(File basedir, ArrayList includes, ArrayList excludes, String testSourceDirectory, String artifactVersion, String artifactClassifier, Properties confOptions, File reportsDirectory) {
        this(basedir, (List)includes, (List)excludes, testSourceDirectory, (ArtifactVersion)new DefaultArtifactVersion(artifactVersion), artifactClassifier, (Map)confOptions, reportsDirectory);
    }

    public TestNGDirectoryTestSuite(File basedir, List includes, List excludes, String testSourceDirectory, ArtifactVersion artifactVersion, String artifactClassifier, Map confOptions, File reportsDirectory) {
        super(basedir, includes, excludes);
        this.options = confOptions;
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
        this.version = artifactVersion;
        this.classifier = artifactClassifier;
    }

    protected SurefireTestSet createTestSet(Class testClass, ClassLoader classLoader) {
        return new TestNGTestSet(testClass);
    }

    public void execute(String testSetName, ReporterManager reporterManager, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        SurefireTestSet testSet = (SurefireTestSet)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        TestNGExecutor.run(new Class[]{testSet.getTestClass()}, this.testSourceDirectory, this.options, this.version, this.classifier, reporterManager, (SurefireTestSuite)this, this.reportsDirectory);
    }

    public void execute(ReporterManager reporterManager, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        ArrayList<Class> testNgTestClasses = new ArrayList<Class>();
        ArrayList<Class> junitTestClasses = new ArrayList<Class>();
        Iterator it = this.testSets.values().iterator();
        while (it.hasNext()) {
            SurefireTestSet testSet;
            Class c;
            if ((class$junit$framework$Test == null ? TestNGDirectoryTestSuite.class$("junit.framework.Test") : class$junit$framework$Test).isAssignableFrom(c = (testSet = (SurefireTestSet)it.next()).getTestClass())) {
                junitTestClasses.add(c);
                continue;
            }
            testNgTestClasses.add(c);
        }
        File testNgReportsDirectory = this.reportsDirectory;
        File junitReportsDirectory = this.reportsDirectory;
        if (junitTestClasses.size() > 0 && testNgTestClasses.size() > 0) {
            testNgReportsDirectory = new File(this.reportsDirectory, "testng-native-results");
            junitReportsDirectory = new File(this.reportsDirectory, "testng-junit-results");
        }
        TestNGDirectoryTestSuite.startTestSuite(reporterManager, (Object)this);
        Class[] testClasses = testNgTestClasses.toArray(new Class[0]);
        TestNGExecutor.run(testClasses, this.testSourceDirectory, this.options, this.version, this.classifier, reporterManager, (SurefireTestSuite)this, testNgReportsDirectory);
        if (junitTestClasses.size() > 0) {
            testClasses = junitTestClasses.toArray(new Class[0]);
            HashMap junitOptions = new HashMap();
            Iterator it2 = this.options.keySet().iterator();
            while (it2.hasNext()) {
                Object key = it2.next();
                junitOptions.put(key, this.options.get(key));
            }
            junitOptions.put("junit", Boolean.TRUE);
            TestNGExecutor.run(testClasses, this.testSourceDirectory, junitOptions, this.version, this.classifier, reporterManager, (SurefireTestSuite)this, junitReportsDirectory);
        }
        TestNGDirectoryTestSuite.finishTestSuite(reporterManager, (Object)this);
    }

    public static void startTestSuite(ReporterManager reporterManager, Object suite) {
        String rawString = bundle.getString("testSetStarting");
        ReportEntry report = new ReportEntry(suite.getClass().getName(), "TestSuite", rawString);
        try {
            reporterManager.testSetStarting(report);
        }
        catch (ReporterException e) {
            // empty catch block
        }
    }

    public static void finishTestSuite(ReporterManager reporterManager, Object suite) {
        String rawString = bundle.getString("testSetCompletedNormally");
        ReportEntry report = new ReportEntry(suite.getClass().getName(), "TestSuite", rawString);
        reporterManager.testSetCompleted(report);
        reporterManager.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

