/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.api.report;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.maven.shadefire.surefire.api.report.RunMode;
import org.apache.maven.shadefire.surefire.api.report.SafeThrowable;
import org.apache.maven.shadefire.surefire.api.report.StackTraceWriter;
import org.apache.maven.shadefire.surefire.api.report.TestSetReportEntry;
import org.apache.maven.shadefire.surefire.api.util.internal.ImmutableMap;

public class SimpleReportEntry
implements TestSetReportEntry {
    private final RunMode runMode;
    private final Long testRunId;
    private final Map<String, String> systemProperties;
    private final String source;
    private final String sourceText;
    private final String name;
    private final String nameText;
    private final StackTraceWriter stackTraceWriter;
    private final Integer elapsed;
    private final String message;

    public SimpleReportEntry(@Nonnull RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText) {
        this(runMode, testRunId, source, sourceText, name, nameText, null, null);
    }

    public SimpleReportEntry(@Nonnull RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, Map<String, String> systemProperties) {
        this(runMode, testRunId, source, sourceText, name, nameText, null, null, systemProperties);
    }

    private SimpleReportEntry(@Nonnull RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, StackTraceWriter stackTraceWriter) {
        this(runMode, testRunId, source, sourceText, name, nameText, stackTraceWriter, null);
    }

    public SimpleReportEntry(@Nonnull RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, Integer elapsed) {
        this(runMode, testRunId, source, sourceText, name, nameText, null, elapsed);
    }

    public SimpleReportEntry(@Nonnull RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, String message) {
        this(runMode, testRunId, source, sourceText, name, nameText, null, null, message, Collections.emptyMap());
    }

    public SimpleReportEntry(@Nonnull RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, StackTraceWriter stackTraceWriter, Integer elapsed, String message, Map<String, String> systemProperties) {
        this.runMode = runMode;
        this.testRunId = testRunId;
        this.source = source;
        this.sourceText = sourceText;
        this.name = name;
        this.nameText = nameText;
        this.stackTraceWriter = stackTraceWriter;
        this.message = message;
        this.elapsed = elapsed;
        this.systemProperties = new ImmutableMap<String, String>(systemProperties);
    }

    public SimpleReportEntry(@Nonnull RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, StackTraceWriter stackTraceWriter, Integer elapsed) {
        this(runMode, testRunId, source, sourceText, name, nameText, stackTraceWriter, elapsed, Collections.emptyMap());
    }

    public SimpleReportEntry(@Nonnull RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, StackTraceWriter stackTraceWriter, Integer elapsed, Map<String, String> systemProperties) {
        this(runMode, testRunId, source, sourceText, name, nameText, stackTraceWriter, elapsed, SimpleReportEntry.safeGetMessage(stackTraceWriter), systemProperties);
    }

    public static SimpleReportEntry assumption(RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, String message) {
        return new SimpleReportEntry(runMode, testRunId, source, sourceText, name, nameText, message);
    }

    public static SimpleReportEntry ignored(RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, String message) {
        return new SimpleReportEntry(runMode, testRunId, source, sourceText, name, nameText, message);
    }

    public static SimpleReportEntry withException(RunMode runMode, Long testRunId, String source, String sourceText, String name, String nameText, StackTraceWriter stackTraceWriter) {
        return new SimpleReportEntry(runMode, testRunId, source, sourceText, name, nameText, stackTraceWriter);
    }

    private static String safeGetMessage(StackTraceWriter stackTraceWriter) {
        try {
            SafeThrowable t = stackTraceWriter == null ? null : stackTraceWriter.getThrowable();
            return t == null ? null : t.getMessage();
        }
        catch (Throwable t) {
            return t.getMessage();
        }
    }

    @Override
    public String getSourceName() {
        return this.source;
    }

    @Override
    public String getSourceText() {
        return this.sourceText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameText() {
        return this.nameText;
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public StackTraceWriter getStackTraceWriter() {
        return this.stackTraceWriter;
    }

    @Override
    public Integer getElapsed() {
        return this.elapsed;
    }

    @Override
    public int getElapsed(int fallback) {
        return this.elapsed == null ? fallback : this.elapsed;
    }

    public String toString() {
        return "ReportEntry{runMode='" + (Object)((Object)this.runMode) + "', testRunId='" + this.testRunId + "', source='" + this.source + "', sourceText='" + this.sourceText + "', name='" + this.name + "', nameText='" + this.nameText + "', stackTraceWriter='" + this.stackTraceWriter + "', elapsed='" + this.elapsed + "', message='" + this.message + "'}";
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleReportEntry that = (SimpleReportEntry)o;
        return this.isRunModeEqual(that) && this.isTestRunIdEqual(that) && this.isSourceEqual(that) && this.isSourceTextEqual(that) && this.isNameEqual(that) && this.isNameTextEqual(that) && this.isStackEqual(that) && this.isElapsedTimeEqual(that) && this.isSystemPropertiesEqual(that) && this.isMessageEqual(that);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.getSourceName());
        result = 31 * result + Objects.hashCode((Object)this.getRunMode());
        result = 31 * result + Objects.hashCode(this.getTestRunId());
        result = 31 * result + Objects.hashCode(this.getSourceText());
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.getNameText());
        result = 31 * result + Objects.hashCode(this.getStackTraceWriter());
        result = 31 * result + Objects.hashCode(this.getElapsed());
        result = 31 * result + Objects.hashCode(this.getSystemProperties());
        result = 31 * result + Objects.hashCode(this.getMessage());
        return result;
    }

    @Override
    public String getNameWithGroup() {
        return this.getSourceName();
    }

    @Override
    public String getReportNameWithGroup() {
        return this.getSourceText();
    }

    @Override
    @Nonnull
    public final RunMode getRunMode() {
        return this.runMode;
    }

    @Override
    public final Long getTestRunId() {
        return this.testRunId;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    private boolean isRunModeEqual(SimpleReportEntry en) {
        return Objects.equals((Object)this.getRunMode(), (Object)en.getRunMode());
    }

    private boolean isTestRunIdEqual(SimpleReportEntry en) {
        return Objects.equals(this.getTestRunId(), en.getTestRunId());
    }

    private boolean isElapsedTimeEqual(SimpleReportEntry en) {
        return Objects.equals(this.getElapsed(), en.getElapsed());
    }

    private boolean isNameTextEqual(SimpleReportEntry en) {
        return Objects.equals(this.getNameText(), en.getNameText());
    }

    private boolean isNameEqual(SimpleReportEntry en) {
        return Objects.equals(this.getName(), en.getName());
    }

    private boolean isSourceEqual(SimpleReportEntry en) {
        return Objects.equals(this.getSourceName(), en.getSourceName());
    }

    private boolean isSourceTextEqual(SimpleReportEntry en) {
        return Objects.equals(this.getSourceText(), en.getSourceText());
    }

    private boolean isStackEqual(SimpleReportEntry en) {
        return Objects.equals(this.getStackTraceWriter(), en.getStackTraceWriter());
    }

    private boolean isSystemPropertiesEqual(SimpleReportEntry en) {
        return Objects.equals(this.getSystemProperties(), en.getSystemProperties());
    }

    private boolean isMessageEqual(SimpleReportEntry en) {
        return Objects.equals(this.getMessage(), en.getMessage());
    }
}

