/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.surefire.shared.utils.logging;

import org.apache.maven.shadefire.surefire.shared.utils.logging.AnsiMessageBuilder;
import org.apache.maven.shadefire.surefire.shared.utils.logging.LoggerLevelRenderer;
import org.apache.maven.shadefire.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.shadefire.surefire.shared.utils.logging.PlainMessageBuilder;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiMode;

public class MessageUtils {
    private static final boolean JANSI;
    private static Thread shutdownHook;
    private static final Object STARTUP_SHUTDOWN_MONITOR;

    public static void systemInstall() {
        if (JANSI) {
            AnsiConsole.systemInstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemUninstall() {
        Object object = STARTUP_SHUTDOWN_MONITOR;
        synchronized (object) {
            MessageUtils.doSystemUninstall();
            if (shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private static void doSystemUninstall() {
        if (JANSI) {
            AnsiConsole.systemUninstall();
        }
    }

    public static void setColorEnabled(boolean flag) {
        if (JANSI) {
            AnsiConsole.out().setMode(flag ? AnsiMode.Force : AnsiMode.Strip);
            Ansi.setEnabled((boolean)flag);
            System.setProperty("jansi.mode", flag ? "force" : "strip");
            boolean installed = AnsiConsole.isInstalled();
            while (AnsiConsole.isInstalled()) {
                AnsiConsole.systemUninstall();
            }
            if (installed) {
                AnsiConsole.systemInstall();
            }
        }
    }

    public static boolean isColorEnabled() {
        return JANSI ? Ansi.isEnabled() : false;
    }

    public static MessageBuilder buffer() {
        return JANSI ? new AnsiMessageBuilder() : new PlainMessageBuilder();
    }

    public static MessageBuilder buffer(StringBuilder builder) {
        return JANSI ? new AnsiMessageBuilder(builder) : new PlainMessageBuilder(builder);
    }

    public static MessageBuilder buffer(int size) {
        return JANSI ? new AnsiMessageBuilder(size) : new PlainMessageBuilder(size);
    }

    public static LoggerLevelRenderer level() {
        return (LoggerLevelRenderer)((Object)(JANSI ? new AnsiMessageBuilder(20) : new PlainMessageBuilder(7)));
    }

    public static String stripAnsiCodes(String msg) {
        return msg.replaceAll("\u001b\\[[;\\d]*[ -/]*[@-~]", "");
    }

    public static void registerShutdownHook() {
        if (JANSI && shutdownHook == null) {
            shutdownHook = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = STARTUP_SHUTDOWN_MONITOR;
                    synchronized (object) {
                        while (AnsiConsole.isInstalled()) {
                            MessageUtils.doSystemUninstall();
                        }
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }

    public static int getTerminalWidth() {
        if (JANSI) {
            int width = AnsiConsole.getTerminalWidth();
            return width > 0 ? width : -1;
        }
        return -1;
    }

    static {
        STARTUP_SHUTDOWN_MONITOR = new Object();
        boolean jansi = true;
        try {
            Class.forName("org.fusesource.jansi.Ansi");
        }
        catch (ClassNotFoundException cnfe) {
            jansi = false;
        }
        JANSI = jansi;
    }
}

