/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.plugin.surefire.log.api;

import org.apache.maven.shadefire.plugin.surefire.log.api.ConsoleLogger;

public final class ConsoleLoggerDecorator
implements ConsoleLogger {
    private final Object logger;

    public ConsoleLoggerDecorator(Object logger) {
        if (logger == null) {
            throw new NullPointerException("logger argument is null in " + ConsoleLoggerDecorator.class);
        }
        this.logger = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.invokeReturnedBoolean("isDebugEnabled");
    }

    @Override
    public void debug(String message) {
        this.invokeWithMessage(message, "debug");
    }

    @Override
    public boolean isInfoEnabled() {
        return this.invokeReturnedBoolean("isInfoEnabled");
    }

    @Override
    public void info(String message) {
        this.invokeWithMessage(message, "info");
    }

    @Override
    public boolean isWarnEnabled() {
        return this.invokeReturnedBoolean("isWarnEnabled");
    }

    @Override
    public void warning(String message) {
        this.invokeWithMessage(message, "warning");
    }

    @Override
    public boolean isErrorEnabled() {
        return this.invokeReturnedBoolean("isErrorEnabled");
    }

    @Override
    public void error(String message) {
        this.invokeWithMessage(message, "error");
    }

    @Override
    public void error(String message, Throwable t) {
        try {
            this.logger.getClass().getMethod("error", String.class, Throwable.class).invoke(this.logger, message, t);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void error(Throwable t) {
        try {
            this.logger.getClass().getMethod("error", Throwable.class).invoke(this.logger, t);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    private boolean invokeReturnedBoolean(String isErrorEnabled) {
        try {
            return (Boolean)this.logger.getClass().getMethod(isErrorEnabled, new Class[0]).invoke(this.logger, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    private void invokeWithMessage(String message, String error) {
        try {
            this.logger.getClass().getMethod(error, String.class).invoke(this.logger, message);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }
}

